/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.test.TestData;
import org.geotools.util.logging.Logging;
import org.geotools.validation.FeatureValidation;
import org.geotools.validation.IntegrityValidation;
import org.geotools.validation.PlugIn;
import org.geotools.validation.Validation;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.geotools.validation.xml.XMLReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationProcessor {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    final Object ANYTYPENAME = new Object();
    protected Map featureLookup = new HashMap();
    protected Map integrityLookup = new HashMap();
    protected ArrayList modifiedFeatureTypes;

    private void addToFVLookup(FeatureValidation validation) {
        String[] featureTypeList = validation.getTypeRefs();
        if (featureTypeList == Validation.ALL) {
            ArrayList<FeatureValidation> tests = (ArrayList<FeatureValidation>)this.featureLookup.get(this.ANYTYPENAME);
            if (tests == null) {
                tests = new ArrayList<FeatureValidation>();
            }
            tests.add(validation);
            this.featureLookup.put(this.ANYTYPENAME, tests);
        } else {
            for (int i = 0; i < featureTypeList.length; ++i) {
                ArrayList<FeatureValidation> tests = (ArrayList<FeatureValidation>)this.featureLookup.get(featureTypeList[i]);
                if (tests == null) {
                    tests = new ArrayList<FeatureValidation>();
                }
                tests.add(validation);
                this.featureLookup.put(featureTypeList[i], tests);
            }
        }
    }

    private void addToIVLookup(IntegrityValidation validation) {
        String[] integrityTypeList = validation.getTypeRefs();
        if (integrityTypeList == Validation.ALL) {
            ArrayList<IntegrityValidation> tests = (ArrayList<IntegrityValidation>)this.integrityLookup.get(this.ANYTYPENAME);
            if (tests == null) {
                tests = new ArrayList<IntegrityValidation>();
            }
            tests.add(validation);
            this.integrityLookup.put(this.ANYTYPENAME, tests);
        } else {
            for (int i = 0; i < integrityTypeList.length; ++i) {
                ArrayList<IntegrityValidation> tests = (ArrayList<IntegrityValidation>)this.integrityLookup.get(integrityTypeList[i]);
                if (tests == null) {
                    tests = new ArrayList<IntegrityValidation>();
                }
                tests.add(validation);
                this.integrityLookup.put(integrityTypeList[i], tests);
            }
        }
    }

    public void addValidation(FeatureValidation validation) {
        this.addToFVLookup(validation);
    }

    public void addValidation(IntegrityValidation validation) {
        this.addToIVLookup(validation);
    }

    public Set getDependencies(String typeName) {
        ArrayList validations = (ArrayList)this.integrityLookup.get(typeName);
        HashSet<String> s = new HashSet<String>();
        if (validations != null) {
            for (int i = 0; i < validations.size(); ++i) {
                String[] types = ((Validation)validations.get(i)).getTypeRefs();
                for (int j = 0; j < types.length; ++j) {
                    s.add(types[j]);
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFeatureTests(String dsID, FeatureCollection<SimpleFeatureType, SimpleFeature> collection, ValidationResults results) throws Exception {
        SimpleFeatureType type = collection.getSchema();
        ArrayList tests = (ArrayList)this.featureLookup.get(this.ANYTYPENAME);
        String typeRef = dsID + ":" + type.getTypeName();
        ArrayList FT_tests = (ArrayList)this.featureLookup.get(typeRef);
        if (FT_tests != null) {
            if (tests != null) {
                Iterator it = FT_tests.iterator();
                while (it.hasNext()) {
                    tests.add((FeatureValidation)it.next());
                }
            } else {
                tests = FT_tests;
            }
        }
        if (tests != null) {
            FeatureIterator<SimpleFeature> features = collection.features();
            try {
                while (features.hasNext()) {
                    SimpleFeature feature = features.next();
                    for (int i = 0; i < tests.size(); ++i) {
                        FeatureValidation validator = (FeatureValidation)tests.get(i);
                        results.setValidation(validator);
                        try {
                            validator.validate(feature, type, results);
                            continue;
                        }
                        catch (Throwable e) {
                            results.error(feature, e.getMessage());
                        }
                    }
                }
            }
            finally {
                collection.close(features);
            }
        }
    }

    public void runIntegrityTests(Set typeRefs, Map stores, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        if (this.integrityLookup == null || this.integrityLookup.size() == 0) {
            LOGGER.fine("No tests defined by integrityLookup - validation not needed");
            return;
        }
        LOGGER.fine("Starting validation tests for:" + typeRefs);
        LOGGER.fine("Marshalled " + stores.size() + " FeatureSources for testing");
        LOGGER.fine("Testing limited to " + envelope);
        if (typeRefs == null) {
            LOGGER.finer("Using default typeRegs for stores");
            typeRefs = stores.keySet();
        } else if (typeRefs.isEmpty()) {
            LOGGER.finer("Validation test abandond - nothing was modified");
        }
        ArrayList tests = new ArrayList();
        LOGGER.finer("Finding tests for everybody");
        List anyTests = (List)this.integrityLookup.get(this.ANYTYPENAME);
        if (anyTests != null && !anyTests.isEmpty()) {
            tests.addAll(anyTests);
        }
        LOGGER.finer("Found " + tests.size() + " tests (so far)");
        LOGGER.finer("Finding tests for modified typeRefs");
        for (String typeRef : typeRefs) {
            LOGGER.finer("Finding tests for typeRef:" + typeRef);
            List moreTests = (List)this.integrityLookup.get(typeRef);
            if (moreTests == null || moreTests.isEmpty()) continue;
            tests.addAll(moreTests);
        }
        if (tests.isEmpty()) {
            LOGGER.finer("Validation test abandond - no tests found to run");
            return;
        }
        LOGGER.finer("Validation test about to run - " + tests.size() + " tests found");
        for (IntegrityValidation validator : tests) {
            LOGGER.finer("Running test:" + validator.getName());
            results.setValidation(validator);
            try {
                boolean success = validator.validate(stores, envelope, results);
                if (success) continue;
                results.error(null, "Was not successful");
            }
            catch (Throwable e) {
                LOGGER.finer("Validation test died:" + validator.getName());
                String error = e.getClass().getName();
                if (e.getMessage() != null) {
                    error = error + " - " + e.getMessage();
                }
                LOGGER.log(Level.WARNING, validator.getName() + " failed with " + error, e);
                e.printStackTrace();
                results.error(null, error);
            }
        }
    }

    protected static final Set queryPlugInNames(Map testSuiteDTOs) {
        HashSet<String> plugInNames = new HashSet<String>();
        for (String testSuite : testSuiteDTOs.keySet()) {
            TestSuiteDTO dto = (TestSuiteDTO)testSuiteDTOs.get(testSuite);
            Iterator j = dto.getTests().keySet().iterator();
            while (j.hasNext()) {
                TestDTO tdto = (TestDTO)dto.getTests().get(j.next());
                plugInNames.add(tdto.getPlugIn().getName());
            }
        }
        return plugInNames;
    }

    public void load(File plugins, File testsuites) throws Exception {
        Map pluginDTOs = XMLReader.loadPlugIns(TestData.file((Object)this, (String)"plugins"));
        Map testSuiteDTOs = XMLReader.loadValidations(TestData.file((Object)this, (String)"validation"), pluginDTOs);
        this.load(testSuiteDTOs, pluginDTOs);
    }

    public void load(Map plugInDTOs, Map testSuiteDTOs) throws Exception {
        PlugIn plugIn;
        Set plugInNames = ValidationProcessor.queryPlugInNames(testSuiteDTOs);
        HashMap<String, PlugIn> plugIns = new HashMap<String, PlugIn>(plugInNames.size());
        for (String plugInName : plugInNames) {
            PlugInDTO dto = (PlugInDTO)plugInDTOs.get(plugInName);
            Class<?> plugInClass = null;
            plugInClass = Class.forName(dto.getClassName());
            if (plugInClass == null) {
                throw new ClassNotFoundException("Could class for " + plugInName + ": class " + dto.getClassName() + " not found");
            }
            HashMap plugInArgs = dto.getArgs();
            if (plugInArgs == null) {
                plugInArgs = new HashMap();
            }
            plugIn = new PlugIn(plugInName, plugInClass, dto.getDescription(), plugInArgs);
            plugIns.put(plugInName, plugIn);
        }
        Iterator<Object> i = testSuiteDTOs.keySet().iterator();
        while (i.hasNext()) {
            TestSuiteDTO tdto = (TestSuiteDTO)testSuiteDTOs.get(i.next());
            Iterator j = tdto.getTests().keySet().iterator();
            while (j.hasNext()) {
                TestDTO dto = (TestDTO)tdto.getTests().get(j.next());
                HashMap testArgs = dto.getArgs();
                if (testArgs == null) {
                    testArgs = new HashMap();
                } else {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    Iterator k = testArgs.keySet().iterator();
                    while (k.hasNext()) {
                        ArgumentDTO adto = (ArgumentDTO)testArgs.get(k.next());
                        m.put(adto.getName(), adto.getValue());
                    }
                    testArgs = m;
                }
                plugIn = (PlugIn)plugIns.get(dto.getPlugIn().getName());
                Validation validation = plugIn.createValidation(dto.getName(), dto.getDescription(), testArgs);
                if (validation instanceof FeatureValidation) {
                    this.addValidation((FeatureValidation)validation);
                }
                if (!(validation instanceof IntegrityValidation)) continue;
                this.addValidation((IntegrityValidation)validation);
            }
        }
    }
}

