/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CatalogWriter {
    Document document;
    Element catalog;
    public static final String COVERAGE_TYPE_KEY = "coverageType";
    public static final String COVERAGE_URL_KEY = "coverageUrl";

    public CatalogWriter() {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            builderFactory.setValidating(false);
            this.document = builderFactory.newDocumentBuilder().newDocument();
            this.catalog = this.document.createElement("catalog");
            this.document.appendChild(this.catalog);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void dataStores(Map dataStores, Map namespaces, Set disabled) {
        Element dataStoresElement = this.document.createElement("datastores");
        this.catalog.appendChild(dataStoresElement);
        for (Map.Entry dataStore : dataStores.entrySet()) {
            String id = (String)dataStore.getKey();
            Map params = (Map)dataStore.getValue();
            Element dataStoreElement = this.document.createElement("datastore");
            dataStoresElement.appendChild(dataStoreElement);
            dataStoreElement.setAttribute("id", id);
            dataStoreElement.setAttribute("enabled", Boolean.toString(!disabled.contains(id)));
            dataStoreElement.setAttribute("namespace", (String)namespaces.get(id));
            Element connectionParamtersElement = this.document.createElement("connectionParams");
            dataStoreElement.appendChild(connectionParamtersElement);
            for (Map.Entry param : params.entrySet()) {
                String name = (String)param.getKey();
                Object value = param.getValue();
                if (value == null) continue;
                Element parameterElement = this.document.createElement("parameter");
                connectionParamtersElement.appendChild(parameterElement);
                parameterElement.setAttribute("name", name);
                parameterElement.setAttribute("value", value.toString());
            }
        }
    }

    public void coverageStores(HashMap coverageStores, HashMap namespaces, Set disabled) {
        Element formatsElement = this.document.createElement("formats");
        this.catalog.appendChild(formatsElement);
        for (Map.Entry dataStore : coverageStores.entrySet()) {
            String id = (String)dataStore.getKey();
            Map params = (Map)dataStore.getValue();
            Element formatElement = this.document.createElement("format");
            formatsElement.appendChild(formatElement);
            formatElement.setAttribute("id", id);
            formatElement.setAttribute("enabled", Boolean.toString(!disabled.contains(id)));
            formatElement.setAttribute("namespace", (String)namespaces.get(id));
            Element typeElement = this.document.createElement("type");
            formatElement.appendChild(typeElement);
            typeElement.setTextContent((String)params.get(COVERAGE_TYPE_KEY));
            Element urlElement = this.document.createElement("url");
            formatElement.appendChild(urlElement);
            urlElement.setTextContent((String)params.get(COVERAGE_URL_KEY));
        }
    }

    public void namespaces(Map namespaces) {
        Element namespacesElement = this.document.createElement("namespaces");
        this.catalog.appendChild(namespacesElement);
        for (Map.Entry namespace : namespaces.entrySet()) {
            String prefix = (String)namespace.getKey();
            String uri = (String)namespace.getValue();
            if ("".equals(prefix)) continue;
            Element namespaceElement = this.document.createElement("namespace");
            namespacesElement.appendChild(namespaceElement);
            namespaceElement.setAttribute("uri", uri);
            namespaceElement.setAttribute("prefix", prefix);
            if (!uri.equals(namespaces.get(""))) continue;
            namespaceElement.setAttribute("default", "true");
        }
    }

    public void styles(Map styles) {
        Element stylesElement = this.document.createElement("styles");
        this.catalog.appendChild(stylesElement);
        for (Map.Entry style : styles.entrySet()) {
            String id = (String)style.getKey();
            String filename = (String)style.getValue();
            Element styleElement = this.document.createElement("style");
            stylesElement.appendChild(styleElement);
            styleElement.setAttribute("id", id);
            styleElement.setAttribute("filename", filename);
        }
    }

    public void write(File file) throws IOException {
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(file);
            tx.transform(source, result);
        }
        catch (Exception e) {
            String msg = "Could not write catalog to " + file;
            throw (IOException)new IOException(msg).initCause(e);
        }
    }
}

