/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gce.imagemosaic.Granule;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.CRS;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RasterManager {
    private static final Logger LOGGER = Logging.getLogger(RasterManager.class);
    final SoftValueHashMap<String, Granule> granulesCache = new SoftValueHashMap();
    private CoordinateReferenceSystem coverageCRS;
    private GeneralEnvelope coverageEnvelope;
    private GridCoverageFactory coverageFactory;
    private String coverageIdentifier;
    private double[] highestRes;
    private Hints hints;
    private URL inputURL;
    private int numberOfOvervies;
    private double[][] overviewsResolution;
    private MathTransform raster2Model;
    OverviewsController overviewsController;
    private GridEnvelope coverageGridrange;
    OverviewPolicy overviewPolicy;
    DecimationController decimationController;
    ImageMosaicReader parent;
    private String locationAttribute;
    private PathType pathType;
    boolean expandMe;
    SpatialDomainManager spatialDomainManager;
    private final GranuleIndex index = new GranuleIndex();

    public RasterManager(ImageMosaicReader reader) throws DataSourceException {
        this.parent = reader;
        this.expandMe = this.parent.expandMe;
        this.inputURL = reader.sourceURL;
        this.locationAttribute = this.parent.locationAttributeName;
        this.coverageIdentifier = reader.getName();
        this.hints = reader.getHints();
        this.coverageEnvelope = reader.getOriginalEnvelope();
        this.coverageGridrange = reader.getOriginalGridRange();
        this.coverageCRS = reader.getCrs();
        this.raster2Model = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
        this.coverageIdentifier = reader.getName();
        this.coverageFactory = reader.getGridCoverageFactory();
        this.pathType = this.parent.pathType;
        this.highestRes = reader.getHighestRes();
        this.numberOfOvervies = reader.getNumberOfOvervies();
        this.overviewsResolution = reader.getOverviewsResolution();
        this.overviewsController = new OverviewsController();
        this.decimationController = new DecimationController();
        try {
            this.spatialDomainManager = new SpatialDomainManager();
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
        catch (FactoryException e) {
            throw new DataSourceException(e);
        }
        this.extractOverviewPolicy();
    }

    private OverviewPolicy extractOverviewPolicy() {
        if (this.hints != null) {
            if (this.hints.containsKey((Object)Hints.OVERVIEW_POLICY)) {
                this.overviewPolicy = (OverviewPolicy)this.hints.get((Object)Hints.OVERVIEW_POLICY);
            } else if (this.hints.containsKey((Object)Hints.IGNORE_COVERAGE_OVERVIEW)) {
                OverviewPolicy overviewPolicy = this.overviewPolicy = (Boolean)this.hints.get((Object)Hints.IGNORE_COVERAGE_OVERVIEW) != false ? OverviewPolicy.IGNORE : OverviewPolicy.QUALITY;
            }
        }
        if (this.overviewPolicy == null) {
            this.overviewPolicy = OverviewPolicy.NEAREST;
        }
        assert (this.overviewPolicy != null);
        return this.overviewPolicy;
    }

    public Collection<GridCoverage2D> read(GeneralParameterValue[] params) throws IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        if (request.isEmpty()) {
            throw new DataSourceException("The provided request resulted in no area to load");
        }
        RasterLayerResponse response = new RasterLayerResponse(request, this);
        GridCoverage2D elem = response.createResponse();
        if (elem != null) {
            return Collections.singletonList(elem);
        }
        return Collections.emptyList();
    }

    public void dispose() {
    }

    List<SimpleFeature> getFeaturesFromIndex(Envelope envelope) throws IOException {
        List<SimpleFeature> features = this.index.findFeatures(envelope);
        if (features != null) {
            return features;
        }
        return Collections.emptyList();
    }

    void getFeaturesFromIndex(Envelope envelope, ItemVisitor visitor) throws IOException {
        this.index.findFeatures(envelope, visitor);
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getLocationAttribute() {
        return this.locationAttribute;
    }

    public URL getInputURL() {
        return this.inputURL;
    }

    public String getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public Hints getHints() {
        return this.hints;
    }

    public CoordinateReferenceSystem getCoverageCRS() {
        return this.coverageCRS;
    }

    public GeneralEnvelope getCoverageEnvelope() {
        return this.coverageEnvelope;
    }

    public GridCoverageFactory getCoverageFactory() {
        return this.coverageFactory;
    }

    public MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    public GridEnvelope getCoverageGridrange() {
        return this.coverageGridrange;
    }

    class SpatialDomainManager {
        ReferencedEnvelope coverageBBox;
        CoordinateReferenceSystem coverageCRS;
        CoordinateReferenceSystem coverageCRS2D;
        GeneralEnvelope coverageEnvelope = null;
        double[] coverageFullResolution;
        ReferencedEnvelope coverageGeographicBBox;
        CoordinateReferenceSystem coverageGeographicCRS2D;
        MathTransform2D coverageGridToWorld2D;
        Rectangle coverageRasterArea;

        public SpatialDomainManager() throws TransformException, FactoryException {
            this.setBaseParameters();
            this.prepareCoverageSpatialElements();
        }

        private void prepareCoverageSpatialElements() throws TransformException, FactoryException {
            this.coverageGeographicBBox = ImageMosaicUtils.getReferencedEnvelopeFromGeographicBoundingBox((GeographicBoundingBox)new GeographicBoundingBoxImpl((org.opengis.geometry.Envelope)this.coverageEnvelope));
            this.coverageGeographicCRS2D = this.coverageGeographicBBox.getCoordinateReferenceSystem();
            this.coverageCRS2D = CRS.getHorizontalCRS(this.coverageCRS);
            assert (this.coverageCRS2D.getCoordinateSystem().getDimension() == 2);
            if (this.coverageCRS.getCoordinateSystem().getDimension() != 2) {
                MathTransform transform = CRS.findMathTransform(this.coverageCRS, this.coverageCRS2D);
                GeneralEnvelope bbox = CRS.transform(transform, (org.opengis.geometry.Envelope)this.coverageEnvelope);
                bbox.setCoordinateReferenceSystem(this.coverageCRS2D);
                this.coverageBBox = new ReferencedEnvelope(bbox);
            } else {
                this.coverageBBox = new ReferencedEnvelope(this.coverageEnvelope);
            }
        }

        private void setBaseParameters() {
            this.coverageEnvelope = RasterManager.this.getCoverageEnvelope().clone();
            this.coverageRasterArea = ((GeneralGridEnvelope)RasterManager.this.getCoverageGridrange()).toRectangle();
            this.coverageCRS = RasterManager.this.getCoverageCRS();
            this.coverageGridToWorld2D = (MathTransform2D)RasterManager.this.getRaster2Model();
            this.coverageFullResolution = new double[2];
            OverviewLevel highestLevel = RasterManager.this.overviewsController.resolutionsLevels.get(0);
            this.coverageFullResolution[0] = highestLevel.resolutionX;
            this.coverageFullResolution[1] = highestLevel.resolutionY;
        }
    }

    class DecimationController {
        void performDecimation(int imageChoice, ImageReadParam readP, RasterLayerRequest request) {
            int h;
            int w;
            double[] requestedRes = request.getRequestedResolution();
            if (requestedRes == null) {
                readP.setSourceSubsampling(1, 1, 0, 0);
                return;
            }
            double[] selectedRes = new double[2];
            int choice = imageChoice;
            if (choice == 0) {
                w = RasterManager.this.coverageGridrange.getSpan(0);
                h = RasterManager.this.coverageGridrange.getSpan(1);
                selectedRes[0] = RasterManager.this.highestRes[0];
                selectedRes[1] = RasterManager.this.highestRes[1];
            } else {
                selectedRes[0] = RasterManager.this.overviewsResolution[choice - 1][0];
                selectedRes[1] = RasterManager.this.overviewsResolution[choice - 1][1];
                w = (int)Math.round(RasterManager.this.coverageEnvelope.getSpan(0) / selectedRes[0]);
                h = (int)Math.round(RasterManager.this.coverageEnvelope.getSpan(1) / selectedRes[1]);
            }
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    class OverviewsController {
        final ArrayList<OverviewLevel> resolutionsLevels = new ArrayList();

        public OverviewsController() {
            this.resolutionsLevels.add(new OverviewLevel(1.0, RasterManager.this.highestRes[0], RasterManager.this.highestRes[1], 0));
            if (RasterManager.this.numberOfOvervies > 0) {
                for (int i = 0; i < RasterManager.this.overviewsResolution.length; ++i) {
                    this.resolutionsLevels.add(new OverviewLevel(RasterManager.this.overviewsResolution[i][0] / RasterManager.this.highestRes[0], RasterManager.this.overviewsResolution[i][0], RasterManager.this.overviewsResolution[i][1], i + 1));
                }
                Collections.sort(this.resolutionsLevels);
            }
        }

        int pickOverviewLevel(OverviewPolicy policy, RasterLayerRequest request) {
            double requestedScaleFactor;
            double requestedScaleFactorY;
            double requestedScaleFactorX;
            if (RasterManager.this.numberOfOvervies <= 0) {
                return 0;
            }
            OverviewLevel max = this.resolutionsLevels.get(0);
            double[] requestedRes = request.getRequestedResolution();
            if (requestedRes != null) {
                double reqx = requestedRes[0];
                double reqy = requestedRes[1];
                requestedScaleFactorX = reqx / max.resolutionX;
                requestedScaleFactorY = reqy / max.resolutionY;
            } else {
                double[] scaleFactors = request.getRequestedRasterScaleFactors();
                if (scaleFactors == null) {
                    return 0;
                }
                requestedScaleFactorX = scaleFactors[0];
                requestedScaleFactorY = scaleFactors[1];
            }
            boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
            double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
            if (requestedScaleFactor <= 1.0) {
                return max.imageChoice;
            }
            OverviewLevel min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
            if (requestedScaleFactor >= min.scaleFactor) {
                return min.imageChoice;
            }
            OverviewLevel prev = max;
            int size = this.resolutionsLevels.size();
            for (int i = 1; i < size; ++i) {
                OverviewLevel curr = this.resolutionsLevels.get(i);
                if (curr.scaleFactor == requestedScaleFactor) {
                    return curr.imageChoice;
                }
                if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                    if (policy == OverviewPolicy.QUALITY) {
                        return prev.imageChoice;
                    }
                    if (policy == OverviewPolicy.SPEED) {
                        return curr.imageChoice;
                    }
                    if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                        return prev.imageChoice;
                    }
                    return curr.imageChoice;
                }
                prev = curr;
            }
            return max.imageChoice;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverviewLevel
    implements Comparable<OverviewLevel> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public OverviewLevel(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(OverviewLevel other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "OverviewLevel[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GranuleIndex {
        private SoftReference<STRtree> index = new SoftReference<Object>(null);

        GranuleIndex() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized SpatialIndex getIndex() throws IOException {
            STRtree tree = this.index.get();
            if (tree == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index needa to be recreated...");
                }
                RasterManager.this.parent.checkShapefileStore();
                FeatureCollection<SimpleFeatureType, SimpleFeature> features = RasterManager.this.parent.featureSource.getFeatures();
                if (features == null && LOGGER.isLoggable(Level.WARNING)) {
                    throw new NullPointerException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature> is null, it's impossible to create an index!");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index Loaded");
                }
                FeatureIterator<SimpleFeature> it = null;
                try {
                    it = features.features();
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException("The provided FeatureCollection<SimpleFeatureType, SimpleFeature>  or empty, it's impossible to create an index!");
                    }
                    tree = new STRtree();
                    while (it.hasNext()) {
                        SimpleFeature feature = it.next();
                        Geometry g = (Geometry)feature.getDefaultGeometry();
                        tree.insert(g.getEnvelopeInternal(), (Object)feature);
                    }
                    tree.build();
                    this.index = new SoftReference<STRtree>(tree);
                }
                finally {
                    if (it != null) {
                        features.close(it);
                    }
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index does not need to be created...");
            }
            return tree;
        }

        public List<SimpleFeature> findFeatures(Envelope envelope) throws IOException {
            if (envelope == null) {
                throw new NullPointerException("The provided envelope cannot be null");
            }
            return this.getIndex().query(envelope);
        }

        public void findFeatures(Envelope envelope, ItemVisitor visitor) throws IOException {
            if (envelope == null) {
                throw new NullPointerException("The provided envelope cannot be null");
            }
            if (visitor == null) {
                throw new NullPointerException("The provided visitor cannot be null");
            }
            this.getIndex().query(envelope, visitor);
        }
    }
}

