/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.index.ItemVisitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.util.ImagingException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.gce.imagemosaic.Granule;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage2D gridCoverage;
    private RasterLayerRequest request;
    private GridCoverageFactory coverageFactory;
    private GeneralEnvelope coverageEnvelope;
    private URL inputURL;
    private boolean frozen = false;
    private RasterManager rasterManager;
    private String parentLocation;
    private Color finalTransparentColor;
    private ParameterBlockJAI pbjMosaic;
    private ReferencedEnvelope mosaicBBox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private int imageChoice = 0;
    private ImageReadParam readParams = new ImageReadParam();
    private boolean multithreadingAllowed = false;
    private boolean alphaIn = false;

    public RasterLayerResponse(RasterLayerRequest request, RasterManager rasterManager) {
        this.request = request;
        this.inputURL = rasterManager.getInputURL();
        File tempFile = new File(this.inputURL.getFile());
        this.parentLocation = tempFile.getParent();
        this.coverageEnvelope = rasterManager.getCoverageEnvelope();
        this.coverageFactory = rasterManager.getCoverageFactory();
        this.rasterManager = rasterManager;
        this.finalTransparentColor = request.getOutputTransparentColor();
        this.multithreadingAllowed = request.isMultithreadingAllowed();
    }

    public GridCoverage2D createResponse() throws IOException {
        this.createCoverage();
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.request;
    }

    private synchronized void createCoverage() throws IOException {
        if (this.request.isEmpty()) {
            throw new IOException("Empty request " + this.request.toString());
        }
        if (this.frozen) {
            return;
        }
        this.gridCoverage = this.assembleGranules();
        this.frozen = true;
    }

    private GridCoverage2D assembleGranules() throws DataSourceException {
        try {
            BoundingBox cropBBOX;
            this.pbjMosaic = new ParameterBlockJAI("Mosaic");
            double[] backgroundValues = this.request.getBackgroundValues();
            this.pbjMosaic.setParameter("backgroundValues", (Object)backgroundValues);
            if (this.request.isBlend()) {
                this.pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_BLEND);
            } else {
                this.pbjMosaic.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            }
            this.mosaicBBox = ReferencedEnvelope.reference(this.request.getCropBBox());
            this.rasterBounds = this.request.getDestinationRasterArea();
            this.finalGridToWorldCorner = (MathTransform2D)PixelTranslation.translate(new AffineTransform2D(this.request.getRequestedGridToWorld()), PixelInCell.CELL_CENTER, PixelInCell.CELL_CORNER);
            this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
            this.imageChoice = this.request.getRequestedBBox() != null && this.request.getRequestedRasterArea() != null ? this.setReadParams(this.request.getOverviewPolicy(), this.readParams, this.request) : 0;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(this.imageChoice).append(" with subsampling factors ").append(this.readParams.getSourceXSubsampling()).append(" ").append(this.readParams.getSourceYSubsampling()).toString());
            }
            ReferencedEnvelope cropEnvelope = (cropBBOX = this.request.getCropBBox()) != null ? ReferencedEnvelope.reference(cropBBOX) : new ReferencedEnvelope(this.coverageEnvelope);
            GranuleIndexVisitor visitor = new GranuleIndexVisitor();
            this.rasterManager.getFeaturesFromIndex(cropEnvelope, visitor);
            visitor.produce();
            if (visitor.granulesNumber >= 1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loaded bbox " + this.mosaicBBox.toString() + " while crop bbox " + this.request.getCropBBox().toString());
                }
                this.buildMosaic();
                return this.gridCoverage;
            }
            if (backgroundValues == null) {
                return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), (RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])new Byte[]{(byte)0}, null), (Envelope)new GeneralEnvelope(this.mosaicBBox));
            }
            Number[] values = new Double[backgroundValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = backgroundValues[i];
            }
            return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), (RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])values, null), (Envelope)new GeneralEnvelope(this.mosaicBBox));
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to create this mosaic", e);
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to create this mosaic", e);
        }
    }

    private RenderedImage processGranuleRaster(RenderedImage granule, int granuleIndex, int[] alphaIndex, boolean alphaIn, PlanarImage[] alphaChannels, boolean doTransparentColor, Color transparentColor) {
        if (this.rasterManager.expandMe && granule.getColorModel() instanceof IndexColorModel) {
            granule = new ImageWorker(granule).forceComponentColorModel().getRenderedImage();
        }
        if (doTransparentColor) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on input image number " + granuleIndex);
            }
            granule = ImageMosaicUtils.makeColorTransparent(transparentColor, granule);
            alphaIndex[0] = granule.getColorModel().getNumComponents() - 1;
        }
        if (alphaIn || doTransparentColor) {
            ImageWorker w = new ImageWorker(granule);
            if (granule.getSampleModel() instanceof MultiPixelPackedSampleModel) {
                w.forceComponentColorModel();
            }
            alphaChannels[granuleIndex] = granule.getColorModel() instanceof IndexColorModel ? w.forceComponentColorModel().retainLastBand().getPlanarImage() : w.retainBands(alphaIndex).getPlanarImage();
        }
        return granule;
    }

    private void buildMosaic() {
        GeneralEnvelope finalenvelope = new GeneralEnvelope(this.mosaicBBox);
        ImageLayout layout = new ImageLayout(this.rasterBounds.x, this.rasterBounds.y, this.rasterBounds.width, this.rasterBounds.height);
        Dimension tileDimensions = this.request.getTileDimensions();
        if (tileDimensions != null) {
            layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        Object preparationImage = JAI.create((String)"Mosaic", (ParameterBlock)this.pbjMosaic, (RenderingHints)hints);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Mosaic created ").toString());
        }
        if (this.finalTransparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final mosaic");
            }
            preparationImage = ImageMosaicUtils.makeColorTransparent(this.finalTransparentColor, (RenderedImage)preparationImage);
        }
        this.gridCoverage = this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), (RenderedImage)preparationImage, (Envelope)finalenvelope);
    }

    private int setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readParams, RasterLayerRequest request) throws IOException, TransformException {
        int imageChoice = 0;
        readParams.setSourceSubsampling(1, 1, 0, 0);
        OverviewPolicy policy = overviewPolicy == null ? this.rasterManager.overviewPolicy : overviewPolicy;
        if (policy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        imageChoice = this.rasterManager.overviewsController.pickOverviewLevel(overviewPolicy, request);
        this.rasterManager.decimationController.performDecimation(imageChoice, readParams, request);
        return imageChoice;
    }

    class GranuleIndexVisitor
    implements ItemVisitor {
        private final List<Future<RenderedImage>> tasks = new ArrayList<Future<RenderedImage>>();
        private int granulesNumber;
        private RenderedImage loadedImage;
        private boolean doInputTransparency;
        private List<ROI> rois = new ArrayList<ROI>();
        private Color inputTransparentColor;
        private PlanarImage[] alphaChannels;

        GranuleIndexVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitItem(Object item) {
            File rasterFile;
            SimpleFeature feature = (SimpleFeature)item;
            String granuleLocation = (String)feature.getAttribute(RasterLayerResponse.this.rasterManager.getLocationAttribute());
            ReferencedEnvelope granuleBBox = ReferencedEnvelope.reference(feature.getBounds());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("About to read image number " + this.granulesNumber);
            }
            if ((rasterFile = RasterLayerResponse.this.rasterManager.getPathType().checkPath(RasterLayerResponse.this.parentLocation, granuleLocation)) == null) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("File found " + granuleLocation);
            }
            Granule granule = null;
            SoftValueHashMap<String, Granule> softValueHashMap = ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache;
            synchronized (softValueHashMap) {
                if (((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.containsKey((Object)rasterFile.toURI().toString())) {
                    granule = (Granule)((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.get((Object)rasterFile.toURI().toString());
                } else {
                    granule = new Granule(granuleBBox, rasterFile);
                    ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.put((Object)rasterFile.toURI().toString(), (Object)granule);
                }
            }
            GranuleLoader loader = new GranuleLoader(RasterLayerResponse.this.readParams, RasterLayerResponse.this.imageChoice, RasterLayerResponse.this.mosaicBBox, RasterLayerResponse.this.finalWorldToGridCorner, granule);
            if (!RasterLayerResponse.this.multithreadingAllowed) {
                this.tasks.add(new FutureTask<RenderedImage>(loader));
            } else {
                this.tasks.add(ImageMosaicReader.multiThreadedLoader.submit(loader));
            }
            ++this.granulesNumber;
        }

        public void produce() {
            this.alphaChannels = new PlanarImage[this.granulesNumber];
            int granuleIndex = 0;
            this.inputTransparentColor = RasterLayerResponse.this.request.getInputTransparentColor();
            this.doInputTransparency = this.inputTransparentColor != null;
            boolean firstGranule = true;
            int[] alphaIndex = null;
            for (Future<RenderedImage> future : this.tasks) {
                block14: {
                    try {
                        if (!RasterLayerResponse.this.multithreadingAllowed) {
                            FutureTask task = (FutureTask)future;
                            task.run();
                        }
                        this.loadedImage = future.get();
                        if (this.loadedImage == null) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Unable to load the raster for granule " + granuleIndex + " with request " + RasterLayerResponse.this.request.toString());
                            continue;
                        }
                        if (!firstGranule) break block14;
                        if (granuleIndex == 0) {
                            ColorModel cm = this.loadedImage.getColorModel();
                            RasterLayerResponse.this.alphaIn = cm.hasAlpha();
                            if (RasterLayerResponse.this.alphaIn || this.doInputTransparency) {
                                alphaIndex = new int[]{cm.getNumComponents() - 1};
                            }
                        }
                        firstGranule = false;
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granule " + granuleIndex, e);
                        continue;
                    }
                    catch (ExecutionException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granule " + granuleIndex, e);
                        continue;
                    }
                    catch (com.sun.media.jai.codecimpl.util.ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Adding to mosaic image number " + granuleIndex + " failed, original request was " + RasterLayerResponse.this.request);
                        continue;
                    }
                    catch (ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Adding to mosaic image number " + granuleIndex + " failed, original request was " + RasterLayerResponse.this.request);
                        continue;
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding to mosaic image number " + granuleIndex);
                }
                RenderedImage raster = RasterLayerResponse.this.processGranuleRaster(this.loadedImage, granuleIndex, alphaIndex, RasterLayerResponse.this.alphaIn, this.alphaChannels, this.doInputTransparency, this.inputTransparentColor);
                this.rois.add((ROI)new ROIShape((Shape)PlanarImage.wrapRenderedImage((RenderedImage)raster).getBounds()));
                RasterLayerResponse.this.pbjMosaic.addSource((Object)raster);
                ++granuleIndex;
            }
            this.granulesNumber = granuleIndex;
            if (this.granulesNumber == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load any granule ");
                }
                return;
            }
            RasterLayerResponse.this.pbjMosaic.setParameter("sourceThreshold", (Object)new double[][]{{ImageMosaicUtils.getThreshold(this.loadedImage.getSampleModel().getDataType())}});
            if (RasterLayerResponse.this.alphaIn || this.doInputTransparency) {
                RasterLayerResponse.this.pbjMosaic.setParameter("sourceAlpha", (Object)this.alphaChannels);
            }
            RasterLayerResponse.this.pbjMosaic.setParameter("sourceROI", (Object)this.rois.toArray(new ROI[this.rois.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GranuleLoader
    implements Callable<RenderedImage> {
        final ReferencedEnvelope cropBBox;
        final MathTransform2D mosaicWorldToGrid;
        final Granule granule;
        final ImageReadParam readParameters;
        final int imageIndex;

        GranuleLoader(ImageReadParam readParameters, int imageIndex, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, Granule granule) {
            this.readParameters = ImageMosaicUtils.cloneImageReadParam(readParameters);
            this.imageIndex = imageIndex;
            this.cropBBox = cropBBox;
            this.mosaicWorldToGrid = mosaicWorldToGrid;
            this.granule = granule;
        }

        public BoundingBox getCropBBox() {
            return this.cropBBox;
        }

        public MathTransform2D getMosaicWorldToGrid() {
            return this.mosaicWorldToGrid;
        }

        public Granule getGranule() {
            return this.granule;
        }

        public ImageReadParam getReadParameters() {
            return this.readParameters;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        @Override
        public RenderedImage call() throws Exception {
            return this.granule.loadGranuleRaster(this.readParameters, this.imageIndex, this.cropBBox, this.mosaicWorldToGrid, RasterLayerResponse.this.request);
        }
    }
}

