/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.ExceptionEvent;
import org.geotools.gce.imagemosaic.MosaicIndexBuilder;
import org.geotools.gce.imagemosaic.ProcessingEvent;
import org.geotools.gce.imagemosaic.ProcessingEventListener;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

class ImageMosaicUtils {
    static final AffineTransform centerToCornerTransformation = AffineTransform.getTranslateInstance(PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    static final AffineTransform cornerToCenterTransformation = AffineTransform.getTranslateInstance(-PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER), -PixelTranslation.getPixelTranslation(PixelInCell.CELL_CORNER));
    static final Logger LOGGER = Logging.getLogger((String)ImageMosaicUtils.class.toString());
    static final String DEFAULT_WILCARD = "*.*";

    ImageMosaicUtils() {
    }

    static boolean createMosaic(String location, String indexName, String wildcard) {
        MosaicIndexBuilder indexBuilder = new MosaicIndexBuilder();
        indexBuilder.setIndexName(indexName);
        indexBuilder.setLocationPath(location);
        indexBuilder.setWildcardString(wildcard);
        final LinkedList exceptions = new LinkedList();
        ProcessingEventListener listener = new ProcessingEventListener(){

            public void exceptionOccurred(ExceptionEvent event) {
                Exception t = event.getException();
                exceptions.add(t);
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                }
            }

            public void getNotification(ProcessingEvent event) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(event.getMessage());
                }
            }
        };
        indexBuilder.addProcessingEventListener(listener);
        indexBuilder.run();
        return exceptions.size() <= 0;
    }

    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        URL sourceURL = null;
        if (source instanceof URL) {
            sourceURL = ImageMosaicUtils.checkURLForMosaicQuery((URL)source);
            source = DataUtilities.urlToFile((URL)sourceURL);
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    sourceURL = ImageMosaicUtils.checkURLForMosaicQuery(sourceURL);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = tempFile.toURI().toURL();
                source = tempFile;
            }
        }
        if (source instanceof File) {
            File sourceFile = (File)source;
            if (!sourceFile.isDirectory()) {
                sourceURL = ((File)source).toURL();
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultWildcardString = DEFAULT_WILCARD;
                String defaultIndexName = FilenameUtils.getName((String)locationPath);
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties")));
                File shapeFile = null;
                for (File propFile : properties) {
                    File shpFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                    if (!shpFile.exists() || !shpFile.canRead() || !propFile.canRead()) continue;
                    shapeFile = shpFile;
                    break;
                }
                if (shapeFile == null) {
                    ImageMosaicUtils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD);
                    shapeFile = new File(locationPath, defaultIndexName + ".shp");
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    sourceURL = !(shapeFile.exists() && shapeFile.canRead() && propertiesFile.exists() && propertiesFile.canRead()) ? null : shapeFile.toURI().toURL();
                } else {
                    sourceURL = shapeFile.toURI().toURL();
                }
            }
        } else {
            sourceURL = null;
        }
        return sourceURL;
    }

    static URL checkURLForMosaicQuery(URL sourceURL) {
        block8: {
            String query;
            if (sourceURL.getProtocol().equalsIgnoreCase("file") && (query = sourceURL.getQuery()) != null) {
                String[] tokens = query.split("\\&");
                String locationPath = sourceURL.getPath();
                String indexName = null;
                File sourceDir = new File(locationPath);
                if (!(sourceDir.isDirectory() && sourceDir.exists() && sourceDir.canRead())) {
                    return null;
                }
                String wildcardString = null;
                for (String token : tokens) {
                    String[] values = token.split("\\=");
                    if (values[0].equalsIgnoreCase("name")) {
                        indexName = values[1];
                        continue;
                    }
                    if (!values[0].equalsIgnoreCase("w") && !values[0].equalsIgnoreCase("wildcard")) continue;
                    wildcardString = values[1];
                }
                File shapeFile = new File(locationPath, indexName + ".shp");
                File propertiesFile = new File(locationPath, indexName + ".properties");
                if (!(shapeFile.exists() && shapeFile.canRead() && propertiesFile.exists() && propertiesFile.canRead())) {
                    ImageMosaicUtils.createMosaic(locationPath, indexName != null ? indexName : FilenameUtils.getBaseName((String)locationPath), wildcardString != null ? wildcardString : DEFAULT_WILCARD);
                }
                if (!(shapeFile.exists() && shapeFile.canRead() && propertiesFile.exists() && propertiesFile.canRead())) {
                    return null;
                }
                try {
                    return shapeFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block8;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return sourceURL;
    }

    static MosaicConfigurationBean loadPropertiesFile(URL sourceURL, CoordinateReferenceSystem crs) {
        String[] pair;
        BufferedInputStream stream;
        String name;
        String path;
        MosaicConfigurationBean retValue = new MosaicConfigurationBean();
        try {
            String temp = DataUtilities.urlToFile((URL)sourceURL.toURI().toURL()).getAbsolutePath();
            path = FilenameUtils.getFullPath((String)temp);
            name = FilenameUtils.getBaseName((String)temp);
        }
        catch (URISyntaxException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        File propertiesFile = new File(path, name + ".properties");
        if (!propertiesFile.exists() || !propertiesFile.isFile()) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Properties file, describing the ImageMoasic, does not exist:" + propertiesFile);
            }
            return null;
        }
        Properties properties = new Properties();
        try {
            stream = new BufferedInputStream(new FileInputStream(propertiesFile));
            properties.load(stream);
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        if (stream != null) {
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (!properties.containsKey("Envelope2D")) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Required key Envelope2D not found.");
            }
            return null;
        }
        String envelope = properties.getProperty("Envelope2D").trim();
        String[] pairs = envelope.split(" ");
        double[][] cornersV = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            pair = pairs[i].split(",");
            cornersV[i][0] = Double.parseDouble(pair[0]);
            cornersV[i][1] = Double.parseDouble(pair[1]);
        }
        GeneralEnvelope originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
        originalEnvelope.setCoordinateReferenceSystem(crs);
        retValue.setEnvelope2D(new Envelope2D(originalEnvelope));
        int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
        retValue.setLevelsNum(levelsNumber);
        if (!properties.containsKey("Levels")) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Required key Levels not found.");
            }
            return null;
        }
        String levels = properties.getProperty("Levels").trim();
        pairs = levels.split(" ");
        if (pairs == null || pairs.length != levelsNumber) {
            LOGGER.severe("Levels number is different from the provided number of levels resoltion.");
            return null;
        }
        double[][] resolutions = new double[levelsNumber][2];
        for (int i = 0; i < levelsNumber; ++i) {
            pair = pairs[i].split(",");
            if (pair == null || pair.length != 2) {
                LOGGER.severe("OverviewLevel number is different from the provided number of levels resoltion.");
                return null;
            }
            resolutions[i][0] = Double.parseDouble(pair[0]);
            resolutions[i][1] = Double.parseDouble(pair[1]);
        }
        retValue.setLevels(resolutions);
        if (!properties.containsKey("Envelope2D")) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Required key Envelope2D not found.");
            }
            return null;
        }
        String coverageName = properties.getProperty("Name").trim();
        retValue.setName(coverageName);
        boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
        retValue.setExpandToRGB(expandMe);
        boolean absolutePath = Boolean.parseBoolean(properties.getProperty("absolutePath", "false").trim());
        retValue.setAbsolutePath(absolutePath);
        retValue.setLocationAttribute(properties.getProperty("LocationAttribute", "location").trim());
        return retValue;
    }

    static double getThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    public static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        ImageMosaicUtils.ensureNonNull("GeographicBoundingBox", geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), DefaultGeographicCRS.WGS84);
    }

    static RenderedImage makeColorTransparent(Color transparentColor, RenderedImage image) throws IllegalStateException {
        ImageWorker w = new ImageWorker(image);
        if (image.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            w.forceComponentColorModel();
        }
        return w.makeColorTransparent(transparentColor).getRenderedImage();
    }

    static ImageReadParam cloneImageReadParam(ImageReadParam param) {
        ImageReadParam newParam = new ImageReadParam();
        if (param.hasController()) {
            newParam.setController(param.getController());
        }
        newParam.setDestination(param.getDestination());
        if (param.getDestinationType() != null) {
            newParam.setDestinationType(param.getDestinationType());
        }
        newParam.setDestinationBands(param.getDestinationBands());
        newParam.setDestinationOffset(param.getDestinationOffset());
        newParam.setSourceBands(param.getSourceBands());
        newParam.setSourceRegion(param.getSourceRegion());
        if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
            newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
        }
        if (param.canSetSourceRenderSize()) {
            newParam.setSourceRenderSize(param.getSourceRenderSize());
        }
        newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        return newParam;
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)105, (Object)name));
        }
    }

    static final class MosaicConfigurationBean {
        private boolean absolutePath;
        private boolean expandToRGB;
        private Envelope2D envelope2D;
        private double[][] levels;
        private String name;
        private int levelsNum;
        private String locationAttribute;

        MosaicConfigurationBean() {
        }

        public boolean isAbsolutePath() {
            return this.absolutePath;
        }

        public void setAbsolutePath(boolean absolutePath) {
            this.absolutePath = absolutePath;
        }

        public boolean isExpandToRGB() {
            return this.expandToRGB;
        }

        public void setExpandToRGB(boolean expandToRGB) {
            this.expandToRGB = expandToRGB;
        }

        public Envelope2D getEnvelope2D() {
            return this.envelope2D;
        }

        public void setEnvelope2D(Envelope2D envelope2D) {
            this.envelope2D = envelope2D;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLevelsNum() {
            return this.levelsNum;
        }

        public void setLevelsNum(int levelsNum) {
            this.levelsNum = levelsNum;
        }

        public double[][] getLevels() {
            return (double[][])this.levels.clone();
        }

        public void setLevels(double[][] levels) {
            this.levels = (double[][])levels.clone();
        }

        public String getLocationAttribute() {
            return this.locationAttribute;
        }

        public void setLocationAttribute(String locationAttribute) {
            this.locationAttribute = locationAttribute;
        }
    }
}

