/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicReader.class);
    static final ExecutorService multiThreadedLoader = new ThreadPoolExecutor(4, 8, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    URL sourceURL;
    AbstractDataStore tileIndexStore;
    private final String typeName;
    final FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    boolean expandMe;
    PathType pathType;
    String locationAttributeName = "location";
    private RasterManager rasterManager;

    public int getGridCoverageCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        super.dispose();
        try {
            if (this.tileIndexStore != null) {
                this.tileIndexStore.dispose();
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            this.tileIndexStore = null;
        }
        this.rasterManager.dispose();
    }

    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        String[] typeNames;
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (this.hints.containsKey((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE)) {
            this.locationAttributeName = (String)this.hints.get((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE);
        }
        if (source == null) {
            IOException ex = new IOException("ImageMosaicReader:No source set to read this coverage.");
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            }
            throw new DataSourceException(ex);
        }
        this.source = source;
        this.sourceURL = ImageMosaicUtils.checkSource(source);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts only File,  URL and String pointing to a file");
        }
        this.tileIndexStore = new ShapefileDataStore(this.sourceURL);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Connected mosaic reader to its data store " + this.sourceURL.toString());
        }
        if ((typeNames = this.tileIndexStore.getTypeNames()).length <= 0) {
            throw new IllegalArgumentException("Problems when opening the index, no typenames for the schema are defined");
        }
        this.typeName = typeNames[0];
        this.featureSource = this.tileIndexStore.getFeatureSource(this.typeName);
        SimpleFeatureType schema = this.featureSource.getSchema();
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, new StringBuffer("Using forced coordinate reference system ").append(this.crs.toWKT()).toString());
        } else {
            CoordinateReferenceSystem tempcrs = this.featureSource.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
            } else {
                this.crs = tempcrs;
            }
        }
        boolean retValue = this.loadProperties();
        if (!retValue) {
            throw new DataSourceException("Unable to create reader for this mosaic.");
        }
        if (this.locationAttributeName == null) {
            for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                if (!attribute.getType().getBinding().equals(String.class)) continue;
                this.locationAttributeName = attribute.getName().toString();
            }
        }
        if (schema.getDescriptor(this.locationAttributeName) == null) {
            throw new DataSourceException("The provided name for the location attribute is invalid.");
        }
        this.rasterManager = new RasterManager(this);
    }

    private boolean loadProperties() {
        ImageMosaicUtils.MosaicConfigurationBean configuration = ImageMosaicUtils.loadPropertiesFile(this.sourceURL, this.crs);
        if (configuration == null) {
            return false;
        }
        this.originalEnvelope = new GeneralEnvelope(configuration.getEnvelope2D());
        this.numOverviews = configuration.getLevelsNum() - 1;
        double[][] resolutions = configuration.getLevels();
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
        this.highestRes = new double[2];
        this.highestRes[0] = resolutions[0][0];
        this.highestRes[1] = resolutions[0][1];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        if (this.numOverviews > 0) {
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = resolutions[i + 1][0];
                this.overViewResolutions[i][1] = resolutions[i + 1][1];
            }
        }
        this.coverageName = configuration.getName();
        this.expandMe = configuration.isExpandToRGB();
        this.originalGridRange = new GeneralGridRange(new Rectangle((int)Math.round(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)this.originalGridRange, this.originalEnvelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        this.raster2Model = geMapper.createTransform();
        this.pathType = configuration.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE;
        this.locationAttributeName = configuration.getLocationAttribute();
        return true;
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        this.checkShapefileStore();
        Collection<GridCoverage2D> response = this.rasterManager.read(params);
        if (response.isEmpty()) {
            throw new DataSourceException("Unable to create a coverage for this request ");
        }
        return (GridCoverage)response.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkShapefileStore() throws DataSourceException {
        ImageMosaicReader imageMosaicReader = this;
        synchronized (imageMosaicReader) {
            if (this.tileIndexStore == null) {
                throw new DataSourceException("This reader was already disposed.");
            }
        }
    }

    Hints getHints() {
        return this.hints;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOvervies() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    String getName() {
        return this.coverageName;
    }

    static {
        try {
            String customTiffName = it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi.class.getName();
            Class.forName(customTiffName);
            String imageioTiffName = TIFFImageReaderSpi.class.getName();
            IIORegistry registry = IIORegistry.getDefaultInstance();
            ImageReaderSpi standard = null;
            ImageReaderSpi custom = null;
            Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, false);
            block2: while (it.hasNext()) {
                ImageReaderSpi provider = it.next();
                String providerClassName = provider.getClass().getName();
                String[] formats = provider.getFormatNames();
                for (int i = 0; i < formats.length; ++i) {
                    if (!formats[i].equalsIgnoreCase("TIFF")) continue;
                    if (providerClassName.equalsIgnoreCase(imageioTiffName)) {
                        standard = provider;
                        continue block2;
                    }
                    if (!providerClassName.equalsIgnoreCase(customTiffName)) continue block2;
                    custom = provider;
                    continue block2;
                }
            }
            if (standard != null && custom != null && !registry.setOrdering(ImageReaderSpi.class, custom, standard)) {
                LOGGER.warning("Unable to set ordering between tiff readers spi");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Unable to load specific TIFF reader spi", e);
        }
    }
}

