/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import javax.swing.SwingUtilities;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.GroupImpl;
import org.apache.commons.cli2.util.HelpFormatter;
import org.geotools.gce.imagemosaic.ExceptionEvent;
import org.geotools.gce.imagemosaic.ProcessingEvent;
import org.geotools.gce.imagemosaic.ProcessingEventListener;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseArgumentsManager {
    public static final long DEFAULT_TILE_CACHE_SIZE = 0x4000000L;
    public static final int DEFAULT_PRIORITY = 5;
    private static final Logger LOGGER = Logging.getLogger((String)BaseArgumentsManager.class.toString());
    private final List<Option> cmdOpts = Collections.synchronizedList(new ArrayList());
    private final Parser cmdParser = new Parser();
    protected final ArgumentBuilder argumentBuilder = new ArgumentBuilder();
    protected final DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
    private Group optionsGroup;
    private CommandLine cmdLine;
    private final Option helpOpt;
    private final Option priorityOpt;
    private final Option versionOpt;
    private final Option tileCacheSizeOpt;
    private long tileCacheSize = 0x4000000L;
    private int priority = 5;
    private String toolName;
    private String version;
    public final boolean DEFAULT_IMAGEIO_CACHING_BEHAVIOUR = false;
    private boolean useImageIOCache = false;
    private boolean sendDelayedMessages = false;
    private volatile boolean stopThread = false;
    private List<ProcessingEventListener> notificationListeners = new ArrayList<ProcessingEventListener>();

    public BaseArgumentsManager(String name, String version) {
        this.toolName = name;
        this.version = version;
        this.versionOpt = this.optionBuilder.withShortName("v").withLongName("versionOpt").withDescription("print the versionOpt.").create();
        this.helpOpt = this.optionBuilder.withShortName("h").withShortName("?").withLongName("helpOpt").withDescription("print this message.").create();
        this.tileCacheSizeOpt = this.optionBuilder.withShortName("c").withLongName("cache_size").withArgument(this.argumentBuilder.withName("c").withMinimum(0).withMaximum(1).create()).withDescription("tile cache size").withRequired(false).create();
        this.priorityOpt = this.optionBuilder.withShortName("p").withLongName("thread_priority").withArgument(this.argumentBuilder.withName("priority").withMinimum(0).withMaximum(1).create()).withDescription("priority for the underlying thread").withRequired(false).create();
        this.cmdOpts.add(this.versionOpt);
        this.cmdOpts.add(this.helpOpt);
        this.cmdOpts.add(this.tileCacheSizeOpt);
        this.cmdOpts.add(this.priorityOpt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOption(Option opt) {
        if (this.cmdLine != null) {
            throw new IllegalStateException();
        }
        List<Option> list = this.cmdOpts;
        synchronized (list) {
            this.cmdOpts.add(opt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeOption(Option opt) {
        if (this.cmdLine != null) {
            throw new IllegalStateException();
        }
        List<Option> list = this.cmdOpts;
        synchronized (list) {
            return this.cmdOpts.remove(opt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeOptions(List<Option> opts) {
        if (this.cmdLine != null) {
            throw new IllegalStateException();
        }
        List<Option> list = this.cmdOpts;
        synchronized (list) {
            return this.cmdOpts.remove(opts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOptions(List<Option> opts) {
        if (this.cmdLine != null) {
            throw new IllegalStateException();
        }
        List<Option> list = this.cmdOpts;
        synchronized (list) {
            this.cmdOpts.addAll(opts);
        }
    }

    protected void finishInitialization() {
        HelpFormatter cmdHlp = new HelpFormatter("| ", "  ", " |", 75);
        cmdHlp.setShellCommand(this.getToolName());
        cmdHlp.setHeader("Help");
        cmdHlp.setFooter(new StringBuffer(this.getToolName() + " - GeoSolutions S.a.s (C) 2006 - v ").append(this.getVersion()).toString());
        cmdHlp.setDivider("|-------------------------------------------------------------------------|");
        this.optionsGroup = new GroupImpl(this.cmdOpts, "Options", "All the options", 1, this.cmdOpts.size());
        this.cmdParser.setGroup(this.optionsGroup);
        this.cmdParser.setHelpOption(this.helpOpt);
        this.cmdParser.setHelpFormatter(cmdHlp);
    }

    public boolean parseArgs(String[] args) {
        this.cmdLine = this.cmdParser.parseAndHelp(args);
        if (this.cmdLine == null) {
            return false;
        }
        if (this.cmdLine.hasOption(this.versionOpt)) {
            System.out.print(new StringBuffer(this.getToolName()).append(" - GeoSolutions S.a.s (C) 2006 - v").append(this.getVersion()).toString());
            return false;
        }
        if (this.cmdLine.hasOption(this.tileCacheSizeOpt)) {
            try {
                this.tileCacheSize = Integer.parseInt((String)this.cmdLine.getValue(this.tileCacheSizeOpt));
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return false;
            }
        }
        if (this.cmdLine.hasOption(this.priorityOpt)) {
            try {
                this.priority = Integer.parseInt((String)this.cmdLine.getValue(this.priorityOpt));
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return false;
            }
        }
        this.setJAIHints();
        return true;
    }

    public boolean hasOption(Option opt) {
        if (this.cmdLine == null) {
            throw new IllegalStateException();
        }
        return this.cmdLine.hasOption(opt);
    }

    public boolean hasOption(String optName) {
        if (this.cmdLine == null) {
            throw new IllegalStateException();
        }
        return this.cmdLine.hasOption(optName);
    }

    public Object getOptionValue(Option opt) {
        if (this.cmdLine == null) {
            throw new IllegalStateException();
        }
        return this.cmdLine.getValue(opt);
    }

    public Object getOptionValue(String optName) {
        if (this.cmdLine == null) {
            throw new IllegalStateException();
        }
        return this.cmdLine.getValue(optName);
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTileCacheSize() {
        return this.tileCacheSize;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setUseImageIOCache(boolean useImageIOCache) {
        this.useImageIOCache = useImageIOCache;
    }

    private void setJAIHints() {
        JAI jaiDef = JAI.getDefaultInstance();
        TileCache cache = jaiDef.getTileCache();
        cache.setMemoryCapacity(this.tileCacheSize * 1024L * 1024L);
        ImageIO.setUseCache(this.useImageIOCache);
    }

    public final synchronized void addProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.add(listener);
    }

    public final synchronized void removeProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.remove(listener);
    }

    public final synchronized void removeAllProcessingEventListeners() {
        this.notificationListeners.clear();
    }

    public synchronized void fireEvent(String string, double percentage) {
        String newLine = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer("Thread Name ");
        message.append(Thread.currentThread().getName()).append(newLine);
        message.append(this.getClass().toString()).append(newLine).append(string);
        ProcessingEvent evt = new ProcessingEvent(this, string, percentage);
        ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
        eventLauncher.setEvent(evt, this.notificationListeners.toArray());
        this.sendEvent(eventLauncher);
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    public synchronized void fireException(String string, double percentage, Exception ex) {
        String newLine = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer("Thread Name ");
        message.append(Thread.currentThread().getName()).append(newLine);
        message.append(this.getClass().toString()).append(newLine).append(string);
        ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
        ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
        eventLauncher.setEvent(evt, this.notificationListeners.toArray());
        this.sendEvent(eventLauncher);
    }

    public synchronized void fireException(Exception ex) {
        this.fireException(ExceptionEvent.getMessageFromException(ex), -1.0, ex);
    }

    public final boolean getStopThread() {
        return this.stopThread;
    }

    public final void stopThread() {
        this.stopThread = true;
    }

    public synchronized void dispose() {
        this.removeAllProcessingEventListeners();
    }

    public abstract void run() throws Throwable;

    protected static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }
}

