/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape.shapehandler.simple;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.renderer.shape.GeometryHandlerUtilities;
import org.geotools.renderer.shape.ScreenMap;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.renderer.shape.SimpleGeometry;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class MultiLineHandler
implements ShapeHandler {
    static final int TOP = 8;
    static final int BOTTOM = 4;
    static final int RIGHT = 2;
    static final int LEFT = 1;
    private ShapeType type;
    private Envelope bbox;
    private MathTransform mt;
    ScreenMap screenMap;
    private Point2D span;

    public MultiLineHandler(ShapeType type, Envelope env, MathTransform mt, boolean hasOpacity, Rectangle screenSize) throws TransformException {
        if (mt == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.bbox = env;
        this.mt = mt;
        this.screenMap = GeometryHandlerUtilities.calculateScreenSize(screenSize, hasOpacity);
        this.span = GeometryHandlerUtilities.calculateSpan(mt, 0, 0);
    }

    public ShapeType getShapeType() {
        return this.type;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return null;
        }
        Envelope geomBBox = GeometryHandlerUtilities.readBounds(buffer);
        if (!this.bbox.intersects(geomBBox)) {
            return null;
        }
        boolean bboxdecimate = geomBBox.getWidth() <= this.span.getX() && geomBBox.getHeight() <= this.span.getY();
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        double[][] coords = new double[numParts][];
        double[][] transformed = new double[numParts][];
        int start = 0;
        int length = 0;
        if (bboxdecimate) {
            coords = new double[][]{new double[4]};
            transformed = new double[][]{new double[4]};
            coords[0][0] = buffer.getDouble();
            coords[0][1] = buffer.getDouble();
            buffer.position(buffer.position() + (numPoints - 2) * 16);
            coords[0][2] = buffer.getDouble();
            coords[0][3] = buffer.getDouble();
            if (!this.bbox.contains(coords[0][0], coords[0][1]) && !this.bbox.contains(coords[0][2], coords[0][3])) {
                return null;
            }
            try {
                this.mt.transform(coords[0], 0, transformed[0], 0, 1);
                if (this.screenMap.get((int)transformed[0][0], (int)transformed[0][1])) {
                    return null;
                }
                this.screenMap.set((int)transformed[0][0], (int)transformed[0][1], true);
                this.mt.transform(coords[0], 2, transformed[0], 2, 1);
                double minx = (int)transformed[0][0];
                double miny = (int)transformed[0][1];
                double maxx = minx + 1.0;
                double maxy = transformed[0][3];
                transformed[0][0] = minx;
                transformed[0][1] = miny;
                transformed[0][2] = maxx;
                transformed[0][3] = maxy;
            }
            catch (Exception e) {
                ShapefileRenderer.LOGGER.severe("could not transform coordinates " + e.getLocalizedMessage());
                transformed[0] = coords[0];
            }
        } else {
            boolean intersection = false;
            int partsInBBox = 0;
            for (int part = 0; part < numParts; ++part) {
                intersection = false;
                start = partOffsets[part];
                int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - start;
                coords[part] = new double[length * 2];
                int readDoubles = 0;
                int currentDoubles = 0;
                int totalDoubles = length * 2;
                while (currentDoubles < totalDoubles) {
                    coords[part][readDoubles] = buffer.getDouble();
                    ++currentDoubles;
                    coords[part][++readDoubles] = buffer.getDouble();
                    intersection = this.bboxIntersectSegment(intersection, coords[part], ++readDoubles);
                    if (readDoubles <= 3 || ++currentDoubles >= totalDoubles - 1 || !(Math.abs(coords[part][readDoubles - 4] - coords[part][readDoubles - 2]) <= this.span.getX()) || !(Math.abs(coords[part][readDoubles - 3] - coords[part][readDoubles - 1]) <= this.span.getY())) continue;
                    readDoubles -= 2;
                }
                if (!intersection) continue;
                if (!this.mt.isIdentity()) {
                    try {
                        transformed[partsInBBox] = new double[readDoubles];
                        GeometryHandlerUtilities.transform(type, this.mt, coords[part], transformed[partsInBBox], readDoubles / 2);
                    }
                    catch (Exception e) {
                        ShapefileRenderer.LOGGER.severe("could not transform coordinates " + e.getLocalizedMessage());
                        transformed[partsInBBox] = coords[part];
                    }
                } else {
                    transformed[partsInBBox] = new double[readDoubles];
                    System.arraycopy(coords[part], 0, transformed[partsInBBox], 0, readDoubles / 2);
                }
                ++partsInBBox;
            }
            if (partsInBBox == 0) {
                return null;
            }
            if (partsInBBox != numParts) {
                double[][] tmp = new double[partsInBBox][];
                System.arraycopy(transformed, 0, tmp, 0, partsInBBox);
                transformed = tmp;
            }
        }
        return this.createGeometry(type, geomBBox, transformed);
    }

    protected Object createGeometry(ShapeType type, Envelope geomBBox, double[][] transformed) {
        return new SimpleGeometry(type, transformed, geomBBox);
    }

    public boolean bboxIntersectSegment(boolean intersection, double[] coords, int index) {
        if (intersection) {
            return true;
        }
        if (this.bbox.contains(coords[index - 2], coords[index - 1])) {
            return true;
        }
        if (index < 4) {
            return false;
        }
        return MultiLineHandler.intersect(coords[index - 4], coords[index - 3], coords[index - 2], coords[index - 1], this.bbox.getMinX(), this.bbox.getMinY(), this.bbox.getMaxX(), this.bbox.getMaxY());
    }

    public static boolean intersect(double x0, double y0, double x1, double y1, double xmin, double ymin, double xmax, double ymax) {
        boolean accept = false;
        boolean done = false;
        int outcode0 = MultiLineHandler.compOutCode(x0, y0, xmin, xmax, ymin, ymax);
        int outcode1 = MultiLineHandler.compOutCode(x1, y1, xmin, xmax, ymin, ymax);
        do {
            double y;
            double x;
            int outcodeOut;
            if (outcode0 == 0 || outcode1 == 0) {
                done = true;
                accept = true;
                continue;
            }
            if ((outcode0 & outcode1) != 0) {
                done = true;
                continue;
            }
            int n = outcodeOut = outcode0 > 0 ? outcode0 : outcode1;
            if ((outcodeOut & 8) > 0) {
                x = x0 + (x1 - x0) * (ymax - y0) / (y1 - y0);
                y = ymax;
            } else if ((outcodeOut & 4) > 0) {
                x = x0 + (x1 - x0) * (ymin - y0) / (y1 - y0);
                y = ymin;
            } else if ((outcodeOut & 2) > 0) {
                y = y0 + (y1 - y0) * (xmax - x0) / (x1 - x0);
                x = xmax;
            } else {
                y = y0 + (y1 - y0) * (xmin - x0) / (x1 - x0);
                x = xmin;
            }
            if (outcodeOut == outcode0) {
                x0 = x;
                y0 = y;
                outcode0 = MultiLineHandler.compOutCode(x0, y0, xmin, xmax, ymin, ymax);
                continue;
            }
            x1 = x;
            y1 = y;
            outcode1 = MultiLineHandler.compOutCode(x1, y1, xmin, xmax, ymin, ymax);
        } while (!done);
        return accept;
    }

    private static int compOutCode(double x, double y, double xmin, double xmax, double ymin, double ymax) {
        int outcode = 0;
        if (y > ymax) {
            outcode |= 8;
        }
        if (y < ymin) {
            outcode |= 4;
        }
        if (x > xmax) {
            outcode |= 2;
        }
        if (x < xmin) {
            outcode |= 1;
        }
        return outcode;
    }

    public void write(ByteBuffer buffer, Object geometry) {
        throw new UnsupportedOperationException("This handler is only for reading");
    }

    public int getLength(Object geometry) {
        return 0;
    }
}

