/*
 * Decompiled with CFR 0.152.
 */
package simple.http.session;

import simple.http.session.DefaultStore;
import simple.http.session.Module;
import simple.http.session.Store;
import simple.http.session.StoreException;
import simple.http.session.StoreFactory;
import simple.util.lease.Cleaner;
import simple.util.lease.Lease;
import simple.util.lease.LeaseManager;
import simple.util.net.Cookie;

final class ModuleFactory {
    private LeaseManager manager;
    private StoreFactory factory;
    private long peroid;

    public ModuleFactory(Cleaner cleaner) {
        this(cleaner, 60000L);
    }

    public ModuleFactory(Cleaner cleaner, long peroid) {
        this.manager = new LeaseManager(cleaner);
        this.factory = new StoreFactory();
        this.peroid = peroid;
    }

    public Module getInstance(Cookie cookie, Object data) {
        Lease lease = this.getLease(cookie.getValue(), this.peroid);
        Store store = this.getStore(cookie, data);
        return new Delegate(store, lease);
    }

    private Lease getLease(String name, long duration) {
        return this.manager.lease(name, duration);
    }

    private Store getStore(Cookie cookie, Object data) {
        Store store = this.factory.getInstance(cookie);
        try {
            store.prepare(data);
        }
        catch (StoreException e) {
            return new DefaultStore(cookie);
        }
        return store;
    }

    private class Delegate
    implements Module {
        private Store store;
        private Lease lease;

        public Delegate(Store store, Lease lease) {
            this.store = store;
            this.lease = lease;
        }

        public Store getStore() {
            return this.store;
        }

        public Lease getLease() {
            return this.lease;
        }
    }
}

