/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import simple.http.serve.Context;
import simple.http.serve.IndexedContent;

final class BufferedContent
extends IndexedContent {
    private volatile byte[] cache;

    public BufferedContent(Context context, String target) {
        super(context, target);
    }

    public void write(OutputStream out) throws IOException {
        if (this.cache == null) {
            int size = this.getLength();
            if (size > 0) {
                this.write(out, size);
            }
        } else {
            out.write(this.cache);
        }
    }

    private void write(OutputStream out, int size) throws IOException {
        InputStream in = this.getInputStream();
        if (size > 0) {
            this.write(out, in, size);
        }
        in.close();
    }

    private void write(OutputStream out, InputStream in, int size) throws IOException {
        byte[] buf = new byte[size];
        int off = 0;
        while (size > 0) {
            int len = in.read(buf, off, size);
            if (len < 0) break;
            out.write(buf, off, len);
            size -= len;
            off += len;
        }
        this.cache = buf;
    }
}

