/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import simple.http.Pipeline;

final class PollerInputStream
extends InputStream {
    private InputStream data;
    private Socket sock;
    private byte[] buf;
    private int size;
    private int pos;

    public PollerInputStream(Pipeline pipe) throws IOException {
        this(pipe, 1024);
    }

    public PollerInputStream(Pipeline pipe, int size) throws IOException {
        this.data = pipe.getInputStream();
        this.buf = new byte[size * 2];
        this.sock = pipe.sock;
    }

    public int read() throws IOException {
        if (this.size > 0) {
            --this.size;
            return this.buf[this.pos++] & 0xFF;
        }
        return this.data.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int last = this.pos + this.size;
        if (this.pos < last) {
            int min = Math.min(len, this.size);
            if (min > 0) {
                System.arraycopy(this.buf, this.pos, b, off, min);
            }
            this.size -= min;
            this.pos += min;
            return min;
        }
        return this.data.read(b, off, len);
    }

    public int available() throws IOException {
        return this.available(1);
    }

    public int available(int timeout) throws IOException {
        if (this.size > 0) {
            return this.size;
        }
        return this.peek(timeout);
    }

    private int peek() throws IOException {
        try {
            int last;
            int read;
            int free = this.buf.length - (this.pos + this.size);
            if (this.pos > this.buf.length / 4) {
                free += this.compact();
            }
            if ((read = this.data.read(this.buf, last = this.pos + this.size, free)) > 0) {
                this.size += read;
            }
            if (read < 0) {
                this.close();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        return this.size;
    }

    private int peek(int timeout) throws IOException {
        int size;
        int wait = this.sock.getSoTimeout();
        if (timeout > 0) {
            this.sock.setSoTimeout(timeout);
        }
        if ((size = this.peek()) != -1) {
            this.sock.setSoTimeout(wait);
        }
        return size;
    }

    private int compact() {
        int space = this.pos;
        if (this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.size);
            this.pos = 0;
        }
        return space;
    }

    public int reset(int count) throws IOException {
        int mark = this.pos;
        if (this.pos - count > 0) {
            this.size += count;
            this.pos -= count;
        } else {
            this.size += this.pos;
            this.pos = 0;
        }
        return mark - this.pos;
    }

    public void close() throws IOException {
        this.data.close();
    }
}

