/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.InputStream;
import simple.http.InputMonitor;
import simple.http.MonitoredInputStream;

class FixedInputStream
extends MonitoredInputStream {
    private boolean finished = false;
    private int count = 0;
    private int limit = 0;
    private boolean open = true;

    public FixedInputStream(InputStream in, InputMonitor mon, int limit) {
        super(in, mon);
        this.limit = limit;
        if (limit <= 0) {
            mon.notifyFinished(in);
            this.finished = true;
        }
    }

    protected int readByte() throws IOException {
        if (this.finished) {
            return -1;
        }
        int octet = this.in.read();
        if (octet < 0 || ++this.count == this.limit) {
            this.mon.notifyFinished(this.in);
            this.finished = true;
        }
        return octet;
    }

    protected int readBytes(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || off > buf.length || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.finished) {
            return -1;
        }
        return this.parseRead(buf, off, len);
    }

    private int parseRead(byte[] buf, int off, int len) throws IOException {
        int remaining = this.limit - this.count;
        int min = Math.min(len, remaining);
        int amount = this.in.read(buf, off, min);
        if (amount < 0) {
            if (this.count == this.limit) {
                this.finished = true;
                return -1;
            }
            throw new IOException("Bad stream");
        }
        if (this.count + amount == this.limit) {
            this.mon.notifyFinished(this.in);
            this.finished = true;
        }
        if (amount > 0) {
            this.count += amount;
        }
        return amount;
    }

    protected int readyBytes() throws IOException {
        return Math.min(this.limit - this.count, this.in.available());
    }

    protected long skipBytes(long amount) throws IOException {
        long min = Math.min(amount, (long)(this.limit - this.count));
        long skipped = this.in.skip(min);
        this.count = (int)((long)this.count + skipped);
        if (this.count == this.limit) {
            this.mon.notifyFinished(this.in);
            this.finished = true;
        }
        return skipped;
    }

    protected void doClose() throws IOException {
        if (!this.finished) {
            this.skip(this.available());
        }
        if (!this.finished) {
            throw new IOException("Bad close");
        }
    }
}

