/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgis;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostgisSQLBuilder
extends DefaultSQLBuilder {
    protected boolean WKBEnabled = false;
    protected boolean byteaEnabled = false;
    protected boolean schemaEnabled = true;
    protected JDBCDataStoreConfig config;

    public PostgisSQLBuilder(int srid, JDBCDataStoreConfig config) {
        this(new SQLEncoderPostgis(srid), config);
    }

    public PostgisSQLBuilder(SQLEncoder encoder, JDBCDataStoreConfig config) {
        super(encoder);
        this.config = config;
    }

    public PostgisSQLBuilder(SQLEncoder encoder, JDBCDataStoreConfig config, SimpleFeatureType ft) {
        super(encoder);
        this.config = config;
        this.ft = ft;
        encoder.setFeatureType(ft);
    }

    public String buildSQLQuery(String typeName, FIDMapper mapper, AttributeDescriptor[] attrTypes, org.opengis.filter.Filter filter, SortBy[] sortBy, Integer offset, Integer limit) throws SQLEncoderException {
        if (offset != null) {
            ArrayList<SortBy> sortAtts = new ArrayList<SortBy>();
            if (sortBy != null) {
                sortAtts.addAll(Arrays.asList(sortBy));
            }
            if (!sortAtts.contains(SortBy.NATURAL_ORDER) && !sortAtts.contains(SortBy.REVERSE_ORDER)) {
                sortAtts.add(SortBy.NATURAL_ORDER);
            }
            sortBy = sortAtts.toArray(new SortBy[sortAtts.size()]);
        }
        String selectStatement = super.buildSQLQuery(typeName, mapper, attrTypes, filter, sortBy, offset, limit);
        StringBuilder sb = new StringBuilder(selectStatement);
        if (offset != null) {
            sb.append(" OFFSET ").append(offset);
        }
        if (limit != null) {
            sb.append(" LIMIT ").append(limit);
        }
        return sb.toString();
    }

    protected void addOrderByPK(StringBuffer sql, FIDMapper mapper, SortOrder sortOrder) throws SQLEncoderException {
        if (mapper == null || mapper.getColumnCount() == 0) {
            throw new SQLEncoderException("NATURAL_ORDER and REVERSE_ORDER is not supported without a primary key");
        }
        String order = SortOrder.ASCENDING == sortOrder ? "ASC" : "DESC";
        int columnCount = mapper.getColumnCount();
        for (int idx = 0; idx < columnCount; ++idx) {
            String colName = mapper.getColumnName(idx);
            sql.append(colName).append(" ").append(order);
            if (idx >= columnCount - 1) continue;
            sql.append(", ");
        }
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeDescriptor[] attributes) {
        int i;
        for (i = 0; i < mapper.getColumnCount(); ++i) {
            sql.append("\"" + mapper.getColumnName(i) + "\"");
            if (attributes.length <= 0 && i >= mapper.getColumnCount() - 1) continue;
            sql.append(", ");
        }
        for (i = 0; i < attributes.length; ++i) {
            AttributeDescriptor attribute = attributes[i];
            if (attribute instanceof GeometryDescriptor) {
                int D;
                GeometryDescriptor geometryAttribute = (GeometryDescriptor)attribute;
                CoordinateReferenceSystem crs = geometryAttribute.getCoordinateReferenceSystem();
                int n = D = crs == null ? 2 : crs.getCoordinateSystem().getDimension();
                if (this.WKBEnabled) {
                    if (this.byteaEnabled) {
                        this.columnGeometryByteaWKB(sql, geometryAttribute, D);
                    } else {
                        this.columnGeometryWKB(sql, geometryAttribute, D);
                    }
                } else {
                    this.columnGeometry(sql, geometryAttribute, D);
                }
            } else {
                this.columnAttribute(sql, attribute);
            }
            if (i >= attributes.length - 1) continue;
            sql.append(", ");
        }
    }

    private void columnGeometryByteaWKB(StringBuffer sql, GeometryDescriptor geometryAttribute, int D) {
        sql.append("encode(");
        if (D == 3) {
            sql.append("asEWKB(");
        } else {
            sql.append("asBinary(");
        }
        this.columnGeometry(sql, geometryAttribute.getLocalName(), D);
        sql.append(",'XDR'),'base64')");
    }

    private void columnGeometryWKB(StringBuffer sql, GeometryDescriptor geometryAttribute, int D) {
        if (D == 3) {
            sql.append("asEWKB(");
        } else {
            sql.append("asBinary(");
        }
        this.columnGeometry(sql, geometryAttribute.getLocalName(), D);
        sql.append(",'XDR')");
    }

    private void columnGeometry(StringBuffer sql, GeometryDescriptor geometryAttribute, int D) {
        if (D == 3 && !this.isForce2D()) {
            sql.append("asEWKT(");
        } else {
            sql.append("asText(");
        }
        this.columnGeometry(sql, geometryAttribute.getLocalName(), D);
        sql.append(")");
    }

    private void columnGeometry(StringBuffer sql, String geomName, int D) {
        if (D == 2 || this.isForce2D()) {
            sql.append("force_2d(\"" + geomName + "\")");
        } else if (D == 3) {
            sql.append("force_3d(\"" + geomName + "\")");
        } else {
            sql.append("force_2d(\"" + geomName + "\")");
        }
    }

    private final void columnAttribute(StringBuffer sql, AttributeDescriptor attribute) {
        sql.append("\"");
        sql.append(attribute.getLocalName());
        sql.append("\"");
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.encodeTableName(typeName));
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null || preFilter == Filter.NONE) {
            String where = this.encoder.encode(preFilter);
            sql.append(" ");
            sql.append(where);
        }
    }

    public boolean isWKBEnabled() {
        return this.WKBEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.WKBEnabled = enabled;
    }

    public boolean isByteaEnabled() {
        return this.byteaEnabled;
    }

    public void setByteaEnabled(boolean byteaEnable) {
        this.byteaEnabled = byteaEnable;
    }

    public void setSchemaEnabled(boolean schemaEnabled) {
        this.schemaEnabled = schemaEnabled;
    }

    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public String encodeTableName(String tableName) {
        return this.schemaEnabled ? "\"" + this.config.getDatabaseSchemaName() + "\".\"" + tableName + "\"" : "\"" + tableName + "\"";
    }

    public String encodeColumnName(String columnName) {
        return "\"" + columnName + "\"";
    }
}

