/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLUnpacker;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class PostgisFeatureStore
extends JDBCFeatureStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    protected static WKTWriter geometryWriter = new WKTWriter();
    protected static GeometryFactory geometryFactory = new GeometryFactory();
    protected static WKTReader geometryReader = new WKTReader(geometryFactory);
    protected static final String CONN_ERROR = "Some sort of database connection error: ";
    protected PostgisSQLBuilder sqlBuilder;
    protected String tableName;
    protected FIDMapper fidMapper;

    public PostgisFeatureStore(PostgisDataStore postgisDataStore, SimpleFeatureType featureType) throws IOException {
        super(postgisDataStore, featureType);
        this.tableName = featureType.getTypeName();
        this.fidMapper = postgisDataStore.getFIDMapper(this.tableName);
        this.sqlBuilder = (PostgisSQLBuilder)postgisDataStore.getSqlBuilder(this.tableName);
        GeometryDescriptor geomType = featureType.getGeometryDescriptor();
        this.queryCapabilities = new JDBCFeatureSource.JDBCQueryCapabilities(featureType){

            public boolean isOffsetSupported() {
                return true;
            }

            protected boolean supportsNaturalOrderSorting() {
                return true;
            }

            protected boolean supportsReverseOrderSorting() {
                return true;
            }

            public boolean isReliableFIDSupported() {
                return !this.isNullFidMapper(PostgisFeatureStore.this.fidMapper);
            }
        };
    }

    protected int getSRID(String geomName) throws IOException {
        return this.getPostgisDataStore().getSRID(this.tableName, geomName);
    }

    private String addQuotes(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }

    public void removeFeatures(Filter filter) throws IOException {
        String sql = "";
        Object whereStmt = null;
        this.assertFilter(filter);
        Filter encodableFilter = this.sqlBuilder.getPreQueryFilter(filter);
        Filter unEncodableFilter = this.sqlBuilder.getPostQueryFilter(filter);
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (encodableFilter == null && unEncodableFilter != null) {
                encodableFilter = this.getEncodableFilter(unEncodableFilter);
            }
            if (encodableFilter != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("DELETE FROM");
                sb.append(this.sqlBuilder.encodeTableName(this.tableName));
                sb.append(" WHERE ");
                this.sqlBuilder.encode(sb, encodableFilter);
                sql = sb.toString();
                LOGGER.fine("sql statment is " + sql);
                DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), filter);
                ReferencedEnvelope bounds = this.bounds((Query)query);
                statement = conn.prepareStatement(sql);
                statement.executeUpdate();
                if (bounds != null && !bounds.isNull()) {
                    this.getJDBCDataStore().listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
                }
            }
            this.close(statement);
        }
        catch (SQLException sqle) {
            this.close(conn, this.getTransaction(), sqle);
            String message = CONN_ERROR + sqle.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, sqle);
        }
        catch (SQLEncoderException ence) {
            String message = "error encoding sql from filter " + ence.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, ence);
        }
        catch (IllegalAttributeException iae) {
            throw new DataSourceException("attribute problem", (Throwable)((Object)iae));
        }
        finally {
            this.close(statement);
            this.close(conn, this.getTransaction(), null);
        }
    }

    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        LOGGER.finer("asserting filter " + filter);
        this.assertFilter(filter);
        boolean fail = false;
        Connection conn = null;
        PreparedStatement statement = null;
        Object fid = null;
        String whereStmt = null;
        Filter encodableFilter = this.sqlBuilder.getPreQueryFilter(filter);
        Filter unEncodableFilter = this.sqlBuilder.getPostQueryFilter(filter);
        try {
            conn = this.getConnection();
            if (encodableFilter == null && unEncodableFilter != null) {
                FidFilter fidFilter = this.getEncodableFilter(unEncodableFilter);
                encodableFilter = fidFilter;
            }
            if (encodableFilter != null) {
                StringBuffer sb = new StringBuffer();
                this.sqlBuilder.encode(sb, encodableFilter);
                whereStmt = "WHERE " + sb;
                String sql = this.makeModifySqlStatement(type, value, whereStmt);
                statement = conn.prepareStatement(sql);
                LOGGER.finer("encoded modify is " + sql);
                this.setModifyPreparedStatementValues(statement, type, value);
                LOGGER.finer("encoded modify is " + sql);
                DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), filter);
                ReferencedEnvelope bounds = this.bounds((Query)query);
                statement.executeUpdate();
                if (bounds != null && !bounds.isNull()) {
                    ReferencedEnvelope afterBounds = this.bounds((Query)query);
                    if (afterBounds != null) {
                        bounds.expandToInclude(afterBounds);
                    }
                } else {
                    bounds = this.bounds((Query)query);
                }
                if (bounds != null && !bounds.isNull()) {
                    this.getJDBCDataStore().listenerManager.fireFeaturesChanged(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
                }
            }
        }
        catch (SQLException sqle) {
            fail = true;
            this.close(conn, this.getTransaction(), sqle);
            String message = CONN_ERROR + sqle.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, sqle);
        }
        catch (SQLEncoderException ence) {
            fail = true;
            String message = "error encoding sql from filter " + ence.getMessage();
            LOGGER.warning(message);
            throw new DataSourceException(message, ence);
        }
        catch (IllegalAttributeException iae) {
            throw new DataSourceException("attribute problem", (Throwable)((Object)iae));
        }
        finally {
            this.close(statement);
            this.close(conn, this.getTransaction(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FidFilter getEncodableFilter(Filter unEncodableFilter) throws IOException, FactoryRegistryException, IllegalAttributeException {
        DefaultQuery query = new DefaultQuery();
        query.setPropertyNames(new String[0]);
        query.setFilter(unEncodableFilter);
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.getFeatures(unEncodableFilter);
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        FidFilter fidFilter = ff.createFidFilter();
        FeatureIterator<SimpleFeature> it = features.features();
        try {
            while (it.hasNext()) {
                SimpleFeature feature = it.next();
                fidFilter.addFid(feature.getID());
            }
        }
        finally {
            features.close(it);
        }
        return fidFilter;
    }

    private String formatFid(SimpleFeature feature) {
        String fid = feature.getID();
        if (fid.startsWith(this.tableName)) {
            fid = fid.substring(this.tableName.length() + 1);
        }
        return this.addQuotes(fid);
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        AttributeDescriptor[] singleType = new AttributeDescriptor[]{type};
        Object[] singleVal = new Object[]{value};
        this.modifyFeatures(singleType, singleVal, filter);
    }

    private String makeModifySqlStatement(AttributeDescriptor[] types, Object[] values, String whereStmt) throws IOException {
        int arrLength = types.length;
        if (arrLength != values.length) {
            throw new IllegalArgumentException("length of value array is not same length as type array");
        }
        StringBuffer sqlStatement = new StringBuffer("UPDATE ");
        sqlStatement.append(this.sqlBuilder.encodeTableName(this.tableName) + " SET ");
        for (int i = 0; i < arrLength; ++i) {
            AttributeDescriptor curType = types[i];
            sqlStatement.append(this.sqlBuilder.encodeColumnName(curType.getLocalName()));
            sqlStatement.append(" = ");
            if (curType instanceof GeometryDescriptor) {
                int srid = this.getSRID(curType.getLocalName());
                sqlStatement.append("GeometryFromText( ?, ").append(srid).append(")");
            } else {
                sqlStatement.append("?");
            }
            sqlStatement.append(i < arrLength - 1 ? ", " : " ");
        }
        sqlStatement.append(whereStmt);
        sqlStatement.append(";");
        return sqlStatement.toString();
    }

    private void setModifyPreparedStatementValues(PreparedStatement statement, AttributeDescriptor[] types, Object[] values) throws IOException, SQLException {
        int arrLength = types.length;
        if (arrLength != values.length) {
            throw new IllegalArgumentException("length of value array is not same length as type array");
        }
        PostgisDataStore dataStore = this.getPostgisDataStore();
        for (int i = 0; i < arrLength; ++i) {
            Object newValue = values[i];
            AttributeDescriptor curType = types[i];
            if (curType instanceof GeometryDescriptor) {
                newValue = geometryWriter.write((Geometry)newValue);
                statement.setObject(1 + i, newValue);
                continue;
            }
            Class target = curType.getType().getBinding();
            int jdbcType = dataStore.getJdbcType(target);
            statement.setObject(1 + i, newValue, jdbcType);
        }
    }

    protected PostgisDataStore getPostgisDataStore() {
        return (PostgisDataStore)super.getJDBCDataStore();
    }

    public String makeSql(SQLUnpacker unpacker, Query query) throws IOException {
        int i;
        boolean useLimit = unpacker.getUnSupported() == null;
        Filter filter = unpacker.getSupported();
        LOGGER.fine("Filter in making sql is " + filter);
        AttributeDescriptor[] attributeTypes = this.getAttTypes(query);
        int numAttributes = attributeTypes.length;
        StringBuffer sqlStatement = new StringBuffer("SELECT ");
        if (!this.fidMapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < this.fidMapper.getColumnCount(); ++i) {
                sqlStatement.append(this.fidMapper.getColumnName(i));
                if (numAttributes <= 0 && i >= this.fidMapper.getColumnCount() - 1) continue;
                sqlStatement.append(", ");
            }
        }
        LOGGER.finer("making sql for " + numAttributes + " attributes");
        for (i = 0; i < numAttributes; ++i) {
            String curAttName = attributeTypes[i].getLocalName();
            if (Geometry.class.isAssignableFrom(attributeTypes[i].getType().getBinding())) {
                sqlStatement.append(", AsText(force_2d(\"" + curAttName + "\"))");
                continue;
            }
            sqlStatement.append(", \"" + curAttName + "\"");
        }
        String where = "";
        if (filter != null) {
            try {
                StringBuffer sb = new StringBuffer();
                this.sqlBuilder.encode(sb, filter);
                where = "WHERE " + sb.toString();
            }
            catch (SQLEncoderException sqle) {
                String message = "Encoder error" + sqle.getMessage();
                LOGGER.warning(message);
                throw new DataSourceException(message, sqle);
            }
        }
        String limit = "";
        if (useLimit) {
            limit = " LIMIT " + query.getMaxFeatures();
        }
        sqlStatement.append(" FROM \"" + this.tableName + "\" " + where + limit + ";").toString();
        LOGGER.fine("sql statement is " + sqlStatement);
        return sqlStatement.toString();
    }

    private AttributeDescriptor[] getAttTypes(Query query) throws IOException {
        AttributeDescriptor[] schemaTypes = this.getSchema().getAttributeDescriptors().toArray(new AttributeDescriptor[this.getSchema().getAttributeDescriptors().size()]);
        if (query.retrieveAllProperties()) {
            return schemaTypes;
        }
        List<String> attNames = Arrays.asList(query.getPropertyNames());
        AttributeDescriptor[] retAttTypes = new AttributeDescriptor[attNames.size()];
        int retPos = 0;
        int n = schemaTypes.length;
        for (int i = 0; i < n; ++i) {
            String schemaTypeName = schemaTypes[i].getLocalName();
            if (!attNames.contains(schemaTypeName)) continue;
            retAttTypes[retPos++] = schemaTypes[i];
        }
        if (attNames.size() != retPos) {
            String msg = "attempted to request a property, " + attNames.get(0) + " that is not part of the schema ";
            throw new IOException(msg);
        }
        return retAttTypes;
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.bounds(query);
    }

    protected ReferencedEnvelope bounds(Query query) throws IOException {
        Filter preFilter;
        Filter filter = query.getFilter();
        if (filter == Filter.EXCLUDE) {
            return new ReferencedEnvelope(new ReferencedEnvelope(), query.getCoordinateSystem());
        }
        SimpleFeatureType schema = this.getSchema();
        JDBCDataStore jdbc = (JDBCDataStore)this.getJDBCDataStore();
        SQLBuilder sqlBuilder = jdbc.getSqlBuilder(schema.getTypeName());
        Filter postQueryFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        if (postQueryFilter != null && !postQueryFilter.equals(Filter.INCLUDE)) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            ReferencedEnvelope retEnv = new ReferencedEnvelope();
            preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
            AttributeDescriptor[] attributeTypes = schema.getAttributeDescriptors().toArray(new AttributeDescriptor[schema.getAttributeDescriptors().size()]);
            SimpleFeatureType schemaNew = schema;
            if (!query.retrieveAllProperties()) {
                try {
                    schemaNew = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])query.getPropertyNames());
                    if (schemaNew.getGeometryDescriptor() == null && schema.getGeometryDescriptor() != null) {
                        ArrayList<String> al = new ArrayList<String>(Arrays.asList(query.getPropertyNames()));
                        al.add(schema.getGeometryDescriptor().getLocalName());
                        schemaNew = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])al.toArray(new String[1]));
                    }
                }
                catch (SchemaException e1) {
                    throw new DataSourceException("Could not create subtype", e1);
                }
            }
            attributeTypes = schemaNew.getAttributeDescriptors().toArray(new AttributeDescriptor[schema.getAttributeDescriptors().size()]);
            int n = schemaNew.getAttributeCount();
            for (int j = 0; j < n; ++j) {
                if (!Geometry.class.isAssignableFrom(attributeTypes[j].getType().getBinding())) continue;
                String attName = attributeTypes[j].getLocalName();
                ReferencedEnvelope curEnv = this.getEnvelope(conn, attName, sqlBuilder, filter);
                if (curEnv == null) {
                    ReferencedEnvelope referencedEnvelope = null;
                    return referencedEnvelope;
                }
                retEnv.expandToInclude(curEnv);
            }
            LOGGER.finer("returning bounds " + retEnv);
            CoordinateReferenceSystem base = null;
            if (query.getCoordinateSystem() != null) {
                base = query.getCoordinateSystem();
            } else if (schemaNew.getGeometryDescriptor() != null) {
                base = schemaNew.getGeometryDescriptor().getCoordinateReferenceSystem();
            }
            CoordinateReferenceSystem dest = query.getCoordinateSystemReproject();
            ReferencedEnvelope result = new ReferencedEnvelope(retEnv, base);
            if (base != null && dest != null) {
                result = result.transform(dest, true);
            }
            ReferencedEnvelope referencedEnvelope = result;
            return referencedEnvelope;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(conn, this.transaction, sqlException);
            conn = null;
            throw new DataSourceException("Could not count " + query.getHandle(), sqlException);
        }
        catch (SQLEncoderException e) {
            preFilter = null;
            return preFilter;
        }
        catch (ParseException parseE) {
            String message = "Could not read geometry: " + parseE.getMessage();
            ReferencedEnvelope referencedEnvelope = null;
            return referencedEnvelope;
        }
        catch (FactoryException e) {
            throw new DataSourceException("Could not reproject", e);
        }
        catch (TransformException e) {
            throw new DataSourceException("Could not reproject", e);
        }
        finally {
            JDBCUtils.close(conn, this.transaction, null);
        }
    }

    protected ReferencedEnvelope getEnvelope(Connection conn, String geomName, SQLBuilder sqlBuilder, Filter filter) throws SQLException, SQLEncoderException, IOException, ParseException {
        boolean useEstimatedExtent;
        String typeName = this.getSchema().getTypeName();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AsText(force_2d(Envelope(");
        boolean bl = useEstimatedExtent = (filter == null || filter == Filter.INCLUDE) && ((PostgisDataStore)this.getDataStore()).isEstimatedExtent();
        if (useEstimatedExtent) {
            sql.append("estimated_extent(");
            sql.append("'" + typeName + "','" + geomName + "'))));");
        } else {
            sql.append("Extent(\"" + geomName + "\")))) ");
            sqlBuilder.sqlFrom(sql, typeName);
            sqlBuilder.sqlWhere(sql, filter);
        }
        LOGGER.fine("SQL: " + sql);
        Statement statement = conn.createStatement();
        ResultSet results = statement.executeQuery(sql.toString());
        results.next();
        String wkt = results.getString(1);
        ReferencedEnvelope retEnv = null;
        if (wkt == null) {
            return null;
        }
        retEnv = ReferencedEnvelope.reference(geometryReader.read(wkt).getEnvelopeInternal());
        results.close();
        statement.close();
        return retEnv;
    }
}

