/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

public class PostgisDataStoreFactory
extends AbstractDataStoreFactory
implements DataStoreFactorySpi {
    private static final String DRIVER_CLASS = "org.postgresql.Driver";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "must be 'postgis'", true, (Object)"postgis");
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "postgis host machine", true, (Object)"localhost");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "postgis connection port (default is 5432)", true, (Object)new Integer(5432));
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "postgis database");
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "postgis schema", false, (Object)"public");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as");
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, (InternationalString)new SimpleInternationalString("password used to login"), false, null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)new Integer(10));
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)new Integer(4));
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "namespace prefix used", false);
    public static final DataAccessFactory.Param WKBENABLED = new DataAccessFactory.Param("wkb enabled", Boolean.class, "set to true if Well Known Binary should be used to read PostGIS data (experimental)", false, (Object)new Boolean(true));
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("loose bbox", Boolean.class, "set to true if the Bounding Box should be 'loose', faster but not as deadly accurate", false, (Object)new Boolean(true));
    public static final DataAccessFactory.Param ESTIMATEDEXTENT = new DataAccessFactory.Param("estimated extent", Boolean.class, "set to true if the bounds for a table should be computed using the 'estimated_extent' function, but beware that this function is less accurate, and in some cases *far* less accurate if the data within the actual bounds does not follow a uniform distribution. It also relies on the fact that you haveaccurate table stats available. So it is a good idea to 'VACUUM ANALYZE' the postgis table.", false, (Object)new Boolean(false));

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("postgis");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        Integer maxConn = (Integer)MAXCONN.lookUp(params);
        Integer minConn = (Integer)MINCONN.lookUp(params);
        Boolean validateConn = (Boolean)VALIDATECONN.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String database = (String)DATABASE.lookUp(params);
        Boolean wkb_enabled = (Boolean)WKBENABLED.lookUp(params);
        Boolean is_loose_bbox = (Boolean)LOOSEBBOX.lookUp(params);
        Boolean is_estimated_extent = (Boolean)ESTIMATEDEXTENT.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        if (!this.canProcess(params)) {
            throw new IOException("The parameters map isn't correct!!");
        }
        boolean validate = validateConn != null && validateConn != false;
        int maxActive = maxConn != null ? maxConn : 10;
        int maxIdle = minConn != null ? minConn : 4;
        ManageableDataSource source = PostgisDataStoreFactory.getDefaultDataSource(host, user, passwd, port, database, maxActive, maxIdle, validate);
        PostgisDataStore dataStore = this.createDataStoreInternal(source, namespace, schema);
        if (wkb_enabled != null) {
            dataStore.setWKBEnabled(wkb_enabled);
        }
        if (is_loose_bbox != null) {
            dataStore.setLooseBbox(is_loose_bbox);
        }
        if (is_estimated_extent != null) {
            dataStore.setOptimizeMode(1);
            dataStore.setEstimatedExtent(is_estimated_extent);
        }
        return dataStore;
    }

    public static ManageableDataSource getDefaultDataSource(String host, String user, String passwd, int port, String database, int maxActive, int minIdle, boolean validate) throws DataSourceException {
        String url = "jdbc:postgresql://" + host + ":" + port + "/" + database;
        String driver = DRIVER_CLASS;
        return DataSourceUtil.buildDefaultDataSource(url, driver, user, passwd, maxActive, minIdle, validate ? "select now()" : null, false, 0);
    }

    protected PostgisDataStore createDataStoreInternal(DataSource dataSource, String namespace, String schema) throws IOException {
        if (schema == null && namespace == null) {
            return new PostgisDataStore(dataSource);
        }
        if (schema == null && namespace != null) {
            return new PostgisDataStore(dataSource, namespace);
        }
        return new PostgisDataStore(dataSource, schema, namespace);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Postgis cannot create a new Database");
    }

    public String getDisplayName() {
        return "Postgis";
    }

    public String getDescription() {
        return "PostGIS spatial database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, HOST, PORT, SCHEMA, DATABASE, USER, PASSWD, MAXCONN, MINCONN, VALIDATECONN, WKBENABLED, LOOSEBBOX, ESTIMATEDEXTENT, NAMESPACE};
    }
}

