/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;

public abstract class Response {
    final Class binding;
    final Set outputFormats;

    public Response(Class binding) {
        this(binding, (Set)null);
    }

    public Response(Class binding, String outputFormat) {
        this(binding, outputFormat == null ? null : Collections.singleton(outputFormat));
    }

    public Response(Class binding, Set outputFormats) {
        if (binding == null) {
            throw new NullPointerException("binding may not be null");
        }
        if (outputFormats == null) {
            outputFormats = Collections.EMPTY_SET;
        }
        this.binding = binding;
        this.outputFormats = outputFormats;
    }

    public final Class getBinding() {
        return this.binding;
    }

    public final String getOutputFormat() {
        if (this.outputFormats.isEmpty()) {
            return null;
        }
        return (String)this.outputFormats.iterator().next();
    }

    public final Set getOutputFormats() {
        return this.outputFormats;
    }

    public boolean canHandle(Operation operation) {
        return true;
    }

    public abstract String getMimeType(Object var1, Operation var2) throws ServiceException;

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        return null;
    }

    public abstract void write(Object var1, OutputStream var2, Operation var3) throws IOException, ServiceException;
}

