/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.web.AbstractFilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class RESTfulPathBasedFilterInvocationDefinitionMap
extends AbstractFilterInvocationDefinitionSource
implements FilterInvocationDefinition {
    private static Log log = LogFactory.getLog(RESTfulPathBasedFilterInvocationDefinitionMap.class);
    private List requestMap = new Vector();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private boolean convertUrlToLowercaseBeforeComparison = false;

    public void addSecureUrl(String antPath, String[] httpMethods, ConfigAttributeDefinition attr) {
        this.requestMap.add(new EntryHolder(antPath, httpMethods, attr));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added Ant path: " + antPath + "; attributes: " + attr + ", httpMethods: " + httpMethods));
            if (httpMethods != null) {
                for (int ii = 0; ii < httpMethods.length; ++ii) {
                    log.debug((Object)("httpMethods[" + ii + "]: " + httpMethods[ii]));
                }
            }
        }
    }

    public void addSecureUrl(String antPath, ConfigAttributeDefinition attr) {
        throw new IllegalArgumentException("addSecureUrl(String, ConfigAttributeDefinition) is INVALID for RESTfulDefinitionSource");
    }

    public Iterator getConfigAttributeDefinitions() {
        HashSet<ConfigAttributeDefinition> set = new HashSet<ConfigAttributeDefinition>();
        for (EntryHolder entryHolder : this.requestMap) {
            set.add(entryHolder.getConfigAttributeDefinition());
        }
        return set.iterator();
    }

    public int getMapSize() {
        return this.requestMap.size();
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.convertUrlToLowercaseBeforeComparison;
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.convertUrlToLowercaseBeforeComparison = convertUrlToLowercaseBeforeComparison;
    }

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.lookupAttributes(url, method);
    }

    public ConfigAttributeDefinition lookupAttributes(String url) {
        throw new IllegalArgumentException("lookupAttributes(String url) is INVALID for RESTfulDefinitionSource");
    }

    public ConfigAttributeDefinition lookupAttributes(String url, String httpMethod) {
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.isConvertUrlToLowercaseBeforeComparison()) {
            url = url.toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'  and httpMethod= " + httpMethod));
            }
        }
        for (EntryHolder entryHolder : this.requestMap) {
            String antPath = entryHolder.getAntPath();
            String[] methodList = entryHolder.getHttpMethodList();
            if (log.isDebugEnabled()) {
                log.debug((Object)("~~~~~~~~~~ antPath= " + antPath + " methodList= " + methodList));
                if (methodList != null) {
                    for (int ii = 0; ii < methodList.length; ++ii) {
                        log.debug((Object)("method[" + ii + "]: " + methodList[ii]));
                    }
                }
            }
            boolean matchedPath = this.pathMatcher.match(antPath, url);
            boolean matchedMethods = true;
            if (methodList != null) {
                matchedMethods = false;
                for (int ii = 0; ii < methodList.length; ++ii) {
                    if (!methodList[ii].equals(httpMethod)) continue;
                    matchedMethods = true;
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Candidate is: '" + url + "'; antPath is " + antPath + "; matchedPath=" + matchedPath + "; matchedMethods=" + matchedMethods));
            }
            if (!matchedPath || !matchedMethods) continue;
            return entryHolder.getConfigAttributeDefinition();
        }
        return null;
    }

    protected class EntryHolder {
        private ConfigAttributeDefinition configAttributeDefinition;
        private String antPath;
        private String[] httpMethodList;

        public EntryHolder(String antPath, String[] httpMethodList, ConfigAttributeDefinition attr) {
            this.antPath = antPath;
            this.configAttributeDefinition = attr;
            this.httpMethodList = httpMethodList;
        }

        protected EntryHolder() {
            throw new IllegalArgumentException("Cannot use default constructor");
        }

        public String getAntPath() {
            return this.antPath;
        }

        public String[] getHttpMethodList() {
            return this.httpMethodList;
        }

        public ConfigAttributeDefinition getConfigAttributeDefinition() {
            return this.configAttributeDefinition;
        }
    }
}

