/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.ConfigAttributeEditor;
import org.acegisecurity.intercept.ObjectDefinitionSource;
import org.geoserver.platform.Operation;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class OperationDefinitionSource
implements ObjectDefinitionSource {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    Map definitions;
    PropertyFileWatcher operationDefinitionFile;

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        if (!(object instanceof Operation)) {
            throw new IllegalArgumentException("Only Operation objects are supported by the OperationDefinitionSource");
        }
        Operation op = (Operation)object;
        this.checkDefinitions();
        OperationKey key = new OperationKey(op.getService().getId(), op.getId());
        ConfigAttributeDefinition result = (ConfigAttributeDefinition)this.definitions.get(key);
        if (result == null) {
            key.operation = null;
            result = (ConfigAttributeDefinition)this.definitions.get(key);
        }
        return result;
    }

    public Iterator getConfigAttributeDefinitions() {
        this.checkDefinitions();
        if (this.definitions != null) {
            return this.definitions.values().iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public boolean supports(Class clazz) {
        return Operation.class.isAssignableFrom(clazz);
    }

    void checkDefinitions() {
        if (this.definitions == null || this.operationDefinitionFile != null && this.operationDefinitionFile.isStale()) {
            try {
                this.definitions = new HashMap();
                if (this.operationDefinitionFile == null) {
                    File dd = GeoserverDataDirectory.getGeoserverDataDirectory();
                    File securityDir = GeoserverDataDirectory.findConfigDir(dd, "security");
                    File securityDefinitions = new File(securityDir, "service.properties");
                    this.operationDefinitionFile = new PropertyFileWatcher(securityDefinitions);
                }
                ConfigAttributeEditor editor = new ConfigAttributeEditor();
                Properties p = this.operationDefinitionFile.getProperties();
                Iterator<Object> it = p.keySet().iterator();
                while (it.hasNext()) {
                    try {
                        String key = (String)it.next();
                        OperationKey okey = new OperationKey(key);
                        editor.setAsText(p.getProperty(key));
                        ConfigAttributeDefinition cad = (ConfigAttributeDefinition)editor.getValue();
                        this.definitions.put(okey, cad);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.log(Level.SEVERE, "Skipping invalid operation security configuration element", e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred loading service security definitions ", e);
            }
        }
    }

    private class OperationKey {
        String service;
        String operation;

        public OperationKey(String service, String operation) {
            this.service = service;
            this.operation = operation;
        }

        public OperationKey(String key) throws IllegalArgumentException {
            if (key.indexOf(46) != -1) {
                String[] elements = key.split("\\.");
                if (elements.length > 2) {
                    throw new IllegalArgumentException("A valid operation key is made of 'service.method', or just 'service'. ");
                }
                this.service = elements[0].trim();
                this.operation = elements[1].trim();
            } else {
                this.service = key;
                this.operation = null;
            }
            if ("".equals(this.service)) {
                throw new IllegalArgumentException("Service must be specified");
            }
            if ("".equals(this.operation)) {
                this.operation = null;
            }
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
            result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OperationKey other = (OperationKey)obj;
            if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
                return false;
            }
            return !(this.service == null ? other.service != null : !this.service.equals(other.service));
        }
    }
}

