/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.GridRange2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogBuilder {
    Catalog catalog;
    WorkspaceInfo workspace;
    StoreInfo store;

    public CatalogBuilder(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public void setStore(StoreInfo store) {
        this.store = store;
    }

    public void updateWorkspace(WorkspaceInfo original, WorkspaceInfo update) {
        this.update(original, update, WorkspaceInfo.class);
    }

    public void updateNamespace(NamespaceInfo original, NamespaceInfo update) {
        this.update(original, update, NamespaceInfo.class);
    }

    public void updateDataStore(DataStoreInfo original, DataStoreInfo update) {
        this.update(original, update, DataStoreInfo.class);
    }

    public void updateCoverageStore(CoverageStoreInfo original, CoverageStoreInfo update) {
        this.update(original, update, CoverageStoreInfo.class);
    }

    public void updateFeatureType(FeatureTypeInfo original, FeatureTypeInfo update) {
        this.update(original, update, FeatureTypeInfo.class);
    }

    public void updateCoverage(CoverageInfo original, CoverageInfo update) {
        this.update(original, update, CoverageInfo.class);
    }

    public void updateLayer(LayerInfo original, LayerInfo update) {
        this.update(original, update, LayerInfo.class);
    }

    public void updateLayerGroup(LayerGroupInfo original, LayerGroupInfo update) {
        this.update(original, update, LayerGroupInfo.class);
    }

    public void updateStyle(StyleInfo original, StyleInfo update) {
        this.update(original, update, StyleInfo.class);
    }

    <T> void update(T original, T update, Class<T> clazz) {
        ClassProperties properties = OwsUtils.getClassProperties(clazz);
        for (String p : properties.properties()) {
            Class<?> type;
            Method setter;
            Method getter = properties.getter(p, null);
            if (getter == null || (setter = properties.setter(p, type = getter.getReturnType())) == null && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type)) continue;
            try {
                Object newValue = getter.invoke(update, null);
                if (newValue == null) continue;
                if (setter == null) {
                    if (Collection.class.isAssignableFrom(type)) {
                        this.updateCollectionProperty(original, (Collection)newValue, getter);
                        continue;
                    }
                    if (!Map.class.isAssignableFrom(type)) continue;
                    this.updateMapProperty(original, (Map)newValue, getter);
                    continue;
                }
                setter.invoke(original, newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void updateCollectionProperty(Object object, Collection newValue, Method getter) throws Exception {
        Collection oldValue = (Collection)getter.invoke(object, null);
        oldValue.clear();
        oldValue.addAll(newValue);
    }

    void updateMapProperty(Object object, Map newValue, Method getter) throws Exception {
        Map oldValue = (Map)getter.invoke(object, null);
        oldValue.clear();
        oldValue.putAll(newValue);
    }

    public DataStoreInfo buildDataStore(String name) {
        DataStoreInfo info = this.catalog.getFactory().createDataStore();
        this.buildStore(info, name);
        return info;
    }

    public CoverageStoreInfo buildCoverageStore(String name) {
        CoverageStoreInfo info = this.catalog.getFactory().createCoverageStore();
        this.buildStore(info, name);
        return info;
    }

    void buildStore(StoreInfo info, String name) {
        info.setName(name);
        info.setEnabled(true);
        if (this.workspace != null) {
            info.setWorkspace(this.workspace);
        } else {
            info.setWorkspace(this.catalog.getDefaultWorkspace());
        }
    }

    public FeatureTypeInfo buildFeatureType(FeatureSource featureSource) throws Exception {
        FeatureType featureType = featureSource.getSchema();
        FeatureTypeInfo ftinfo = this.catalog.getFactory().createFeatureType();
        ftinfo.setStore(this.store);
        ftinfo.setEnabled(true);
        ftinfo.setNativeName(featureType.getName().getLocalPart());
        ftinfo.setName(featureType.getName().getLocalPart());
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        ftinfo.setNamespace(namespace);
        ReferencedEnvelope bounds = featureSource.getBounds();
        ftinfo.setNativeBoundingBox(bounds);
        CoordinateReferenceSystem crs = featureType.getCoordinateReferenceSystem();
        if (crs == null) {
            crs = bounds.getCoordinateReferenceSystem();
        }
        ReferencedEnvelope boundsLatLon = null;
        if (crs != null) {
            if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs)) {
                try {
                    boundsLatLon = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("transform error").initCause(e);
                }
            } else {
                boundsLatLon = new ReferencedEnvelope(bounds);
            }
        }
        ftinfo.setLatLonBoundingBox(boundsLatLon);
        if (crs != null) {
            try {
                ftinfo.setSRS(CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true));
            }
            catch (FactoryException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        return ftinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFeatureType(FeatureTypeInfo featureType) throws Exception {
        Integer epsgCode;
        SimpleFeatureType ft;
        CoordinateReferenceSystem crs;
        if (featureType.getNativeName() == null && featureType.getName() != null) {
            featureType.setNativeName(featureType.getName());
        }
        if (featureType.getNativeName() != null && featureType.getName() == null) {
            featureType.setName(featureType.getNativeName());
        }
        if (featureType.getLatLonBoundingBox() == null) {
            if (featureType.getNativeBoundingBox() != null) {
                featureType.setLatLonBoundingBox(featureType.getNativeBoundingBox().transform(CRS.decode((String)"EPSG:4326"), true));
            }
        } else if (featureType.getNativeBoundingBox() == null) {
            // empty if block
        }
        if (featureType.getNativeBoundingBox() == null) {
            FeatureSource source = this.catalog.getResourcePool().getFeatureSource(featureType, null);
            ReferencedEnvelope bounds = source.getBounds();
            if (bounds == null) {
                FeatureCollection features = source.getFeatures();
                FeatureIterator fi = features.features();
                try {
                    while (fi.hasNext()) {
                        SimpleFeature f = (SimpleFeature)fi.next();
                        if (bounds == null) {
                            bounds = new ReferencedEnvelope(f.getBounds());
                            continue;
                        }
                        bounds.include(f.getBounds());
                    }
                }
                finally {
                    features.close(fi);
                }
            }
            featureType.setNativeBoundingBox(bounds);
            featureType.setLatLonBoundingBox(bounds.transform(CRS.decode((String)"EPSG:4326"), true));
        }
        if (featureType.getSRS() == null && (crs = (ft = this.catalog.getResourcePool().getFeatureType(featureType)).getCoordinateReferenceSystem()) != null && (epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true)) != null) {
            featureType.setSRS("EPSG:" + epsgCode);
        }
    }

    public CoverageInfo buildCoverage(AbstractGridCoverage2DReader reader) throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        CoverageInfo cinfo = this.catalog.getFactory().createCoverage();
        cinfo.setStore(csinfo);
        cinfo.setEnabled(true);
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        cinfo.setNamespace(namespace);
        CoordinateReferenceSystem nativeCRS = reader.getCrs();
        cinfo.setNativeCRS(nativeCRS);
        if (nativeCRS != null && !nativeCRS.getIdentifiers().isEmpty()) {
            cinfo.setSRS(nativeCRS.getIdentifiers().toArray()[0].toString());
        } else {
            cinfo.setSRS("UNKNOWN");
        }
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        cinfo.setNativeBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope));
        cinfo.setLatLonBoundingBox(new ReferencedEnvelope((org.opengis.geometry.Envelope)CoverageStoreUtils.getWGS84LonLatEnvelope((GeneralEnvelope)envelope)));
        GeneralGridRange originalRange = reader.getOriginalGridRange();
        cinfo.setGrid((GridGeometry)new GridGeometry2D((GridEnvelope)originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), nativeCRS));
        AbstractGridFormat format = csinfo.getFormat();
        ParameterValueGroup readParams = format.getReadParameters();
        Map parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)readParams);
        int minX = originalRange.getLower(0);
        int minY = originalRange.getLower(1);
        int width = originalRange.getLength(0);
        int height = originalRange.getLength(1);
        int maxX = minX + (width <= 5 ? width : 5);
        int maxY = minY + (height <= 5 ? height : 5);
        GridRange2D testRange = new GridRange2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (org.opengis.geometry.Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(nativeCRS);
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)testRange, (org.opengis.geometry.Envelope)testEnvelope));
        GridCoverage2D gc = (GridCoverage2D)reader.read(CoverageUtils.getParameters((ParameterValueGroup)readParams, (Map)parameters, (boolean)true));
        if (gc == null) {
            throw new Exception("Unable to acquire test coverage for format:" + format.getName());
        }
        cinfo.getDimensions().addAll(this.getCoverageDimensions(gc.getSampleDimensions()));
        String name = gc.getName().toString();
        cinfo.setName(name);
        cinfo.setTitle(new StringBuffer(name).append(" is a ").append(format.getDescription()).toString());
        cinfo.setDescription(new StringBuffer("Generated from ").append(format.getName()).toString());
        MetadataLinkInfo ml = this.catalog.getFactory().createMetadataLink();
        ml.setAbout(format.getDocURL());
        ml.setMetadataType("other");
        cinfo.getMetadataLinks().add(ml);
        cinfo.getKeywords().add("WCS");
        cinfo.getKeywords().add(format.getName());
        cinfo.getKeywords().add(name);
        cinfo.setNativeFormat(format.getName());
        cinfo.getMetadata().put("dirName", (Serializable)((Object)new StringBuffer(this.store.getName()).append("_").append(name).toString()));
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            cinfo.getRequestSRS().add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        if (gc.getCoordinateReferenceSystem2D().getIdentifiers() != null && !gc.getCoordinateReferenceSystem2D().getIdentifiers().isEmpty()) {
            cinfo.getResponseSRS().add(((Identifier)gc.getCoordinateReferenceSystem2D().getIdentifiers().toArray()[0]).toString());
        }
        List formats = CoverageStoreUtils.listDataFormats();
        for (Format fTmp : formats) {
            String fName = fTmp.getName();
            if (fName.equalsIgnoreCase("WorldImage")) {
                cinfo.getSupportedFormats().add("GIF");
                cinfo.getSupportedFormats().add("PNG");
                cinfo.getSupportedFormats().add("JPEG");
                cinfo.getSupportedFormats().add("TIFF");
                continue;
            }
            if (fName.toLowerCase().startsWith("geotiff")) {
                cinfo.getSupportedFormats().add("GEOTIFF");
                continue;
            }
            cinfo.getSupportedFormats().add(fName);
        }
        cinfo.setDefaultInterpolationMethod("nearest neighbor");
        cinfo.getInterpolationMethods().add("nearest neighbor");
        cinfo.getInterpolationMethods().add("bilinear");
        cinfo.getInterpolationMethods().add("bicubic");
        cinfo.getParameters().putAll(CoverageUtils.getParametersKVP((ParameterValueGroup)format.getReadParameters()));
        return cinfo;
    }

    List<CoverageDimensionInfo> getCoverageDimensions(GridSampleDimension[] sampleDimensions) {
        int length = sampleDimensions.length;
        ArrayList<CoverageDimensionInfo> dims = new ArrayList<CoverageDimensionInfo>();
        for (int i = 0; i < length; ++i) {
            CoverageDimensionInfo dim = this.catalog.getFactory().createCoverageDimension();
            dim.setName(sampleDimensions[i].getDescription().toString(Locale.getDefault()));
            StringBuffer label = new StringBuffer("GridSampleDimension".intern());
            Unit uom = sampleDimensions[i].getUnits();
            if (uom != null) {
                label.append("(".intern());
                this.parseUOM(label, uom);
                label.append(")".intern());
            }
            label.append("[".intern());
            label.append(sampleDimensions[i].getMinimumValue());
            label.append(",".intern());
            label.append(sampleDimensions[i].getMaximumValue());
            label.append("]".intern());
            dim.setDescription(label.toString());
            dim.setRange(sampleDimensions[i].getRange());
            List categories = sampleDimensions[i].getCategories();
            if (categories == null) continue;
            for (Category cat : categories) {
                if (cat == null || !cat.getName().toString().equalsIgnoreCase("no data")) continue;
                double min = cat.getRange().getMinimum();
                double max = cat.getRange().getMaximum();
                dim.getNullValues().add(min);
                if (min == max) continue;
                dim.getNullValues().add(max);
            }
        }
        return dims;
    }

    void parseUOM(StringBuffer label, Unit uom) {
        String uomString = uom.toString();
        uomString = uomString.replaceAll("\ufffd", "^2");
        uomString = uomString.replaceAll("\ufffd", "^3");
        uomString = uomString.replaceAll("\ufffd", "A");
        uomString = uomString.replaceAll("\ufffd", "");
        label.append(uomString);
    }

    public LayerInfo buildLayer(FeatureTypeInfo featureType) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)featureType);
        String styleName = null;
        Class gtype = featureType.getFeatureType().getGeometryDescriptor().getType().getBinding();
        styleName = Point.class.isAssignableFrom(gtype) || MultiPoint.class.isAssignableFrom(gtype) ? "point" : (LineString.class.isAssignableFrom(gtype) || MultiLineString.class.isAssignableFrom(gtype) ? "line" : (Polygon.class.isAssignableFrom(gtype) || MultiPolygon.class.isAssignableFrom(gtype) ? "polygon" : "point"));
        StyleInfo style = this.catalog.getStyleByName(styleName);
        layer.setDefaultStyle(style);
        layer.getStyles().add(style);
        return layer;
    }

    public LayerInfo buildLayer(CoverageInfo coverage) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)coverage);
        StyleInfo style = this.catalog.getStyleByName("raster");
        layer.setDefaultStyle(style);
        layer.getStyles().add(style);
        return layer;
    }

    LayerInfo buildLayer(ResourceInfo resource) {
        LayerInfo layer = this.catalog.getFactory().createLayer();
        layer.setName(resource.getName());
        layer.setEnabled(true);
        layer.setResource(resource);
        return layer;
    }

    public void calculateLayerGroupBounds(LayerGroupInfo lg) throws Exception {
        if (lg.getLayers().isEmpty()) {
            return;
        }
        LayerInfo l = lg.getLayers().get(0);
        ReferencedEnvelope bounds = l.getResource().getBoundingBox();
        boolean latlon = false;
        if (bounds == null) {
            bounds = l.getResource().getLatLonBoundingBox();
            latlon = true;
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
        }
        for (int i = 1; i < lg.getLayers().size(); ++i) {
            l = lg.getLayers().get(i);
            ReferencedEnvelope re = latlon ? l.getResource().getLatLonBoundingBox() : l.getResource().getBoundingBox();
            if (!CRS.equalsIgnoreMetadata((Object)bounds.getCoordinateReferenceSystem(), (Object)re.getCoordinateReferenceSystem())) {
                re = re.transform(bounds.getCoordinateReferenceSystem(), true);
            }
            if (re == null) {
                throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
            }
            bounds.expandToInclude((Envelope)re);
        }
        lg.setBounds(bounds);
    }
}

