/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output;

import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import it.geosolutions.imageio.stream.output.FileImageOutputStreamExt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileImageOutputStreamExtImpl
extends ImageOutputStreamImpl
implements FileImageOutputStreamExt {
    protected EnhancedRandomAccessFile eraf;
    protected File file;

    public FileImageOutputStreamExtImpl(File file) throws FileNotFoundException, IOException {
        this.file = file;
        this.eraf = new EnhancedRandomAccessFile(file, "rw");
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public FileImageOutputStreamExtImpl(File file, int bufSize) throws FileNotFoundException, IOException {
        this.file = file;
        this.eraf = new EnhancedRandomAccessFile(file, "rw", bufSize);
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.eraf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int nbytes = this.eraf.read(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.eraf.write(b);
        ++this.streamPos;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.eraf.write(b, off, len);
        this.streamPos += (long)len;
    }

    public long length() {
        try {
            this.checkClosed();
            return this.eraf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.eraf.seek(pos);
        this.streamPos = this.eraf.getFilePointer();
    }

    public void close() throws IOException {
        super.close();
        this.eraf.close();
    }

    public File getFile() {
        return this.file;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return new StringBuffer("FileImageOutputStreamExtImpl which points to ").append(this.file.toString()).toString();
    }
}

