/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.spi;

import com.sun.imageio.spi.FileImageInputStreamSpi;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class FileImageInputStreamExtImplSpi
extends ImageInputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.input.spi");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class inputClass = File.class;

    public FileImageInputStreamExtImplSpi() {
        super(vendorName, version, inputClass);
    }

    public String getDescription(Locale locale) {
        return "Service provider that wraps a FileImageInputStream";
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        Class<ImageInputStreamSpi> targetClass = ImageInputStreamSpi.class;
        Iterator<ImageInputStreamSpi> i = registry.getServiceProviders(targetClass, true);
        while (i.hasNext()) {
            ImageInputStreamSpi other = i.next();
            if (other instanceof FileImageInputStreamSpi) {
                registry.deregisterServiceProvider(other);
            }
            if (this == other) continue;
            registry.setOrdering(targetClass, this, other);
        }
    }

    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) {
        if (!(input instanceof File)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("THe provided input is not a eraf.");
            }
            return null;
        }
        try {
            return new FileImageInputStreamExtImpl((File)input);
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }
}

