/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input;

import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;

public final class FileImageInputStreamExtImpl
extends ImageInputStreamImpl
implements FileImageInputStreamExt {
    protected File file;
    protected EnhancedRandomAccessFile eraf;

    public byte readByte() throws IOException {
        return this.eraf.readByte();
    }

    public char readChar() throws IOException {
        return this.eraf.readChar();
    }

    public double readDouble() throws IOException {
        return this.eraf.readDouble();
    }

    public float readFloat() throws IOException {
        return this.eraf.readFloat();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.eraf.readFully(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.eraf.readFully(b);
    }

    public int readInt() throws IOException {
        return this.eraf.readInt();
    }

    public String readLine() throws IOException {
        return this.eraf.readLine();
    }

    public ByteOrder getByteOrder() {
        return this.eraf.getByteOrder();
    }

    public long getStreamPosition() throws IOException {
        return this.eraf.getFilePointer();
    }

    public boolean isCached() {
        return this.eraf.isCached();
    }

    public int read(byte[] b) throws IOException {
        return this.eraf.read(b);
    }

    public long skipBytes(long n) throws IOException {
        return this.eraf.skipBytes(n);
    }

    public long readLong() throws IOException {
        return this.eraf.readLong();
    }

    public short readShort() throws IOException {
        return this.eraf.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.eraf.readUnsignedByte();
    }

    public long readUnsignedInt() throws IOException {
        return this.eraf.readUnsignedInt();
    }

    public int readUnsignedShort() throws IOException {
        return this.eraf.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.eraf.readUTF();
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.eraf.setByteOrder(byteOrder);
    }

    public int skipBytes(int n) throws IOException {
        return this.eraf.skipBytes(n);
    }

    public FileImageInputStreamExtImpl(File f) throws FileNotFoundException, IOException {
        this(f, -1);
    }

    public FileImageInputStreamExtImpl(File f, int bufferSize) throws FileNotFoundException, IOException {
        if (f == null) {
            throw new NullPointerException("f == null!");
        }
        StringBuilder buff = new StringBuilder("Invalid input file provided");
        if (!f.exists() || f.isDirectory()) {
            buff.append("exists: ").append(f.exists()).append("\n");
            buff.append("isDirectory: ").append(f.isDirectory()).append("\n");
            throw new FileNotFoundException(buff.toString());
        }
        if (!f.exists() || f.isDirectory() || !f.canRead()) {
            buff.append("canRead: ").append(f.canRead()).append("\n");
            throw new IOException(buff.toString());
        }
        this.file = f;
        this.eraf = bufferSize <= 0 ? new EnhancedRandomAccessFile(f, "r") : new EnhancedRandomAccessFile(f, "r", bufferSize);
        this.eraf.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.eraf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int nbytes = this.eraf.read(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    public long length() {
        try {
            this.checkClosed();
            return this.eraf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IllegalArgumentException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.eraf.seek(pos);
        this.streamPos = this.eraf.getFilePointer();
    }

    public void close() throws IOException {
        super.close();
        this.eraf.close();
    }

    public File getFile() {
        return this.file;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return new StringBuffer("FileImageInputStreamExtImpl which points to ").append(this.file.toString()).toString();
    }
}

