/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.eclipse.xsd.XSDSchema;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Binding;
import org.geotools.xml.Configuration;
import org.geotools.xml.DOMParser;
import org.geotools.xml.Encoder;
import org.geotools.xml.XSD;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.BindingWalkerFactoryImpl;
import org.geotools.xml.impl.NamespaceSupportWrapper;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class XMLTestSupport
extends TestCase {
    protected static Logger logger = Logging.getLogger((String)"org.geotools.xml.test");
    protected Document document;
    protected HashMap namespaceMappings;

    protected void setUp() throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        this.document = docFactory.newDocumentBuilder().newDocument();
        this.namespaceMappings = new HashMap();
    }

    protected void registerNamespaces(Element root) {
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    protected void registerNamespaceMapping(String prefix, String uri) {
        this.namespaceMappings.put(prefix, uri);
    }

    protected abstract Configuration createConfiguration();

    protected Object parse(QName type) throws Exception {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            throw new IllegalStateException("Document has no root element");
        }
        Configuration config = this.createConfiguration();
        if (type != null) {
            config.getContext().registerComponentInstance((Object)"http://geotools.org/typeDefinition", (Object)type);
        }
        this.registerNamespaces(root);
        for (Map.Entry mapping : this.namespaceMappings.entrySet()) {
            String prefix = (String)mapping.getKey();
            String uri = (String)mapping.getValue();
            root.setAttribute("xmlns:" + prefix, uri);
        }
        root.setAttribute("xsi:schemaLocation", config.getNamespaceURI() + " " + config.getSchemaFileURL());
        DOMParser parser = new DOMParser(config, this.document);
        return parser.parse();
    }

    protected Object parse() throws Exception {
        return this.parse(null);
    }

    protected Document encode(Object object, QName element, QName type) throws Exception {
        Configuration configuration = this.createConfiguration();
        if (type != null) {
            configuration.getContext().registerComponentInstance((Object)"http://geotools.org/typeDefinition", (Object)type);
        }
        XSDSchema schema = configuration.getXSD().getSchema();
        Encoder encoder = new Encoder(configuration, schema);
        for (Map.Entry mapping : this.namespaceMappings.entrySet()) {
            String prefix = (String)mapping.getKey();
            String uri = (String)mapping.getValue();
            encoder.getNamespaces().declarePrefix(prefix, uri);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        encoder.write(object, element, output);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(output.toByteArray()));
    }

    protected Document encode(Object object, QName element) throws Exception {
        return this.encode(object, element, null);
    }

    protected void print(Node dom) throws Exception {
        TransformerFactory txFactory = TransformerFactory.newInstance();
        Transformer tx = txFactory.newTransformer();
        tx.setOutputProperty("indent", "yes");
        tx.transform(new DOMSource(dom), new StreamResult(System.out));
    }

    protected Binding binding(QName name) {
        Configuration configuration = this.createConfiguration();
        DefaultPicoContainer context = new DefaultPicoContainer();
        context = configuration.setupContext((MutablePicoContainer)context);
        Map bindings = configuration.setupBindings();
        BindingLoader bindingLoader = new BindingLoader(bindings);
        context.registerComponentInstance((Object)new BindingFactoryImpl(bindingLoader));
        context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(bindingLoader, (MutablePicoContainer)context));
        context.registerComponentInstance((Object)logger);
        NamespaceSupport namespaces = new NamespaceSupport();
        HashMap mappings = new HashMap();
        try {
            for (XSD xsd : configuration.getXSD().getDependencies()) {
                XSDSchema schema = xsd.getSchema();
                mappings.putAll(schema.getQNamePrefixToNamespaceMap());
            }
            mappings.putAll(configuration.getXSD().getSchema().getQNamePrefixToNamespaceMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry mapping : mappings.entrySet()) {
            String key = (String)mapping.getKey();
            if (key == null) {
                key = "";
            }
            namespaces.declarePrefix(key, (String)mapping.getValue());
        }
        context.registerComponentInstance((Object)namespaces);
        context.registerComponentInstance((Object)new NamespaceSupportWrapper(namespaces));
        context.registerComponentInstance((Object)configuration);
        return bindingLoader.loadBinding(name, (MutablePicoContainer)context);
    }

    protected void buildDocument(String xml) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        this.document = docFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
    }

    protected Element getElementByQName(Document dom, QName name) {
        return this.getElementByQName(dom.getDocumentElement(), name);
    }

    protected Element getElementByQName(Element parent, QName name) {
        NodeList nodes = parent.getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
        if (nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    protected NodeList getElementsByQName(Document dom, QName name) {
        return this.getElementsByQName(dom.getDocumentElement(), name);
    }

    protected NodeList getElementsByQName(Element parent, QName name) {
        return parent.getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
    }
}

