/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.net.URL;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.geotools.xml.XSD;

public class SchemaLocationResolver
implements XSDSchemaLocationResolver {
    protected XSD xsd;

    public SchemaLocationResolver(XSD xsd) {
        this.xsd = xsd;
    }

    public boolean canHandle(XSDSchema schema, String uri, String location) {
        if (this.xsd.getNamespaceURI().equals(uri)) {
            String fileName = new File(location).getName();
            URL xsdLocation = this.xsd.getClass().getResource(fileName);
            return xsdLocation != null;
        }
        return false;
    }

    public String resolveSchemaLocation(XSDSchema schema, String uri, String location) {
        if (location == null) {
            return null;
        }
        if ((uri == null || "".equals(uri)) && schema != null) {
            uri = schema.getTargetNamespace();
        }
        if (this.canHandle(schema, uri, location)) {
            String fileName = new File(location).getName();
            return this.xsd.getClass().getResource(fileName).toString();
        }
        return null;
    }

    public String toString() {
        return this.xsd.toString();
    }
}

