/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.resources.Utilities;
import org.geotools.xml.SchemaLocationResolver;
import org.geotools.xml.SchemaLocator;
import org.geotools.xml.XSD;
import org.geotools.xml.impl.PicoMap;
import org.geotools.xs.XSConfiguration;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public abstract class Configuration {
    private final XSD xsd;
    private final List dependencies;
    private final Set properties;
    private final MutablePicoContainer context;

    public Configuration(XSD xsd) {
        this.xsd = xsd;
        this.dependencies = new ArrayList();
        if (!(this instanceof XSConfiguration)) {
            this.dependencies.add(new XSConfiguration());
        }
        this.properties = Collections.synchronizedSet(new HashSet());
        this.context = new DefaultPicoContainer();
    }

    public XSD getXSD() {
        return this.xsd;
    }

    public final List getDependencies() {
        return this.dependencies;
    }

    public final Set getProperties() {
        return this.properties;
    }

    public final boolean hasProperty(QName property) {
        for (Configuration configuration : this.allDependencies()) {
            if (!configuration.getProperties().contains(property)) continue;
            return true;
        }
        return false;
    }

    public final List allDependencies() {
        LinkedList<Configuration> unpacked = new LinkedList<Configuration>();
        Stack<Configuration> stack = new Stack<Configuration>();
        stack.push(this);
        while (!stack.isEmpty()) {
            Configuration c = (Configuration)stack.pop();
            if (unpacked.contains(c)) continue;
            unpacked.addFirst(c);
            stack.addAll(c.getDependencies());
        }
        return unpacked;
    }

    protected void addDependency(Configuration dependency) {
        if (this.dependencies.contains(dependency)) {
            return;
        }
        this.dependencies.add(dependency);
    }

    public final String getNamespaceURI() {
        return this.getXSD().getNamespaceURI();
    }

    public final String getSchemaFileURL() {
        return this.getXSD().getSchemaLocation();
    }

    public final XSDSchemaLocationResolver getSchemaLocationResolver() {
        return new SchemaLocationResolver(this.xsd);
    }

    public final XSDSchemaLocator getSchemaLocator() {
        return new SchemaLocator(this.xsd);
    }

    public XSDSchema schema() {
        try {
            return this.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final MutablePicoContainer getContext() {
        return this.context;
    }

    public final MutablePicoContainer setupBindings(MutablePicoContainer container) {
        for (Configuration dependency : this.allDependencies()) {
            dependency.registerBindings(container);
        }
        container = container.makeChildContainer();
        this.configureBindings(container);
        return container;
    }

    public final Map setupBindings() {
        HashMap bindings = new HashMap();
        PicoMap container = new PicoMap(bindings);
        for (Configuration dependency : this.allDependencies()) {
            dependency.registerBindings(bindings);
            dependency.registerBindings(container);
        }
        for (Configuration dependency : this.allDependencies()) {
            dependency.configureBindings(bindings);
            dependency.configureBindings(container);
        }
        return bindings;
    }

    protected void registerBindings(MutablePicoContainer container) {
    }

    protected void registerBindings(Map bindings) {
    }

    protected void configureBindings(MutablePicoContainer container) {
    }

    protected void configureBindings(Map bindings) {
    }

    public final MutablePicoContainer setupContext(MutablePicoContainer container) {
        List dependencies = this.allDependencies();
        for (Configuration dependency : dependencies) {
            XSDSchemaLocator locator;
            XSDSchemaLocationResolver resolver = dependency.getSchemaLocationResolver();
            if (resolver != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocationResolver");
                container.registerComponentInstance((Object)key, (Object)resolver);
            }
            if ((locator = dependency.getSchemaLocator()) != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocator");
                container.registerComponentInstance((Object)key, (Object)locator);
            }
            ArrayList properties = new ArrayList(dependency.getProperties());
            for (QName property : properties) {
                try {
                    container.registerComponentInstance((Object)property, (Object)property);
                }
                catch (DuplicateComponentKeyRegistrationException e) {}
            }
            container = container.makeChildContainer();
            dependency.configureContext(container);
        }
        if (!this.context.getComponentAdapters().isEmpty()) {
            container = container.makeChildContainer();
            for (ComponentAdapter adapter : this.context.getComponentAdapters()) {
                container.registerComponent(adapter);
            }
        }
        return container;
    }

    protected void configureContext(MutablePicoContainer container) {
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Configuration) {
            Configuration other = (Configuration)obj;
            return Utilities.equals((Object)this.getNamespaceURI(), (Object)other.getNamespaceURI());
        }
        return false;
    }

    public final int hashCode() {
        if (this.getNamespaceURI() != null) {
            return this.getNamespaceURI().hashCode();
        }
        return 0;
    }
}

