/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.format;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.MapModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.PageInfo;
import org.geoserver.rest.format.DataFormat;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;

public class ReflectiveHTMLFormat
extends DataFormat {
    Request request;
    Response response;
    Resource resource;
    protected Class clazz;

    public ReflectiveHTMLFormat(Request request, Response response, Resource resource) {
        this(null, request, response, resource);
    }

    public ReflectiveHTMLFormat(Class clazz, Request request, Response response, Resource resource) {
        super(MediaType.TEXT_HTML);
        this.clazz = clazz;
        this.request = request;
        this.resource = resource;
    }

    public Representation toRepresentation(Object object) {
        Class<?> clazz = this.clazz != null ? this.clazz : object.getClass();
        Configuration configuration = this.createConfiguration(object, clazz);
        final ObjectWrapper wrapper = configuration.getObjectWrapper();
        configuration.setObjectWrapper(new ObjectWrapper(){

            public TemplateModel wrap(Object obj) throws TemplateModelException {
                PageInfo pageInfo;
                SimpleHash hash;
                TemplateModel model = wrapper.wrap(obj);
                if (model instanceof SimpleHash && (hash = (SimpleHash)model).get("page") == null && (pageInfo = (PageInfo)ReflectiveHTMLFormat.this.request.getAttributes().get("org.geoserver.pageDetails")) != null) {
                    hash.put("page", (Object)pageInfo);
                }
                return model;
            }
        });
        Template template = null;
        String templateName = this.getTemplateName(object);
        if (templateName != null) {
            try {
                template = configuration.getTemplate(templateName);
            }
            catch (IOException e) {
                try {
                    template = configuration.getTemplate(templateName + ".ftl");
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        if (template == null && this.request != null) {
            String r = this.request.getResourceRef().getLastSegment();
            int i = r.lastIndexOf(".");
            if (i != -1) {
                r = r.substring(0, i);
            }
            try {
                template = configuration.getTemplate(r + ".ftl");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        while (template == null && clazz != null) {
            try {
                template = configuration.getTemplate(clazz.getSimpleName() + ".ftl");
            }
            catch (IOException e) {
                // empty catch block
            }
            for (Class<?> interfaze : clazz.getInterfaces()) {
                try {
                    template = configuration.getTemplate(interfaze.getSimpleName() + ".ftl");
                    break;
                }
                catch (IOException e) {
                }
            }
            if (clazz.getSuperclass() == Object.class) break;
            clazz = clazz.getSuperclass();
        }
        templateName = template != null ? template.getName() : "Object.ftl";
        return new TemplateRepresentation(templateName, configuration, object, this.getMediaType());
    }

    protected Configuration createConfiguration(Object data, Class clazz) {
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper(new ObjectToMapWrapper(clazz));
        cfg.setClassForTemplateLoading(ReflectiveHTMLFormat.class, "");
        return cfg;
    }

    public Object readRepresentation(Representation representation) {
        throw new UnsupportedOperationException("Reading not implemented.");
    }

    protected String getTemplateName(Object data) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ObjectToMapWrapper<T>
    extends BeansWrapper {
        Class<T> clazz;

        public ObjectToMapWrapper(Class<T> clazz) {
            this.clazz = clazz;
        }

        public TemplateModel wrap(Object object) throws TemplateModelException {
            Object o;
            Collection c;
            if (object instanceof Collection && !(c = (Collection)object).isEmpty() && this.clazz.isAssignableFrom((o = c.iterator().next()).getClass())) {
                SimpleHash hash = new SimpleHash();
                hash.put("values", (Object)new CollectionModel(c, (BeansWrapper)this));
                return hash;
            }
            if (object != null && this.clazz.isAssignableFrom(object.getClass())) {
                HashMap<String, String> map = new HashMap<String, String>();
                ClassProperties cp = OwsUtils.getClassProperties(this.clazz);
                for (String p : cp.properties()) {
                    if ("Class".equals(p)) continue;
                    Object value = OwsUtils.get((Object)object, (String)p);
                    if (value == null) {
                        value = "null";
                    }
                    map.put(Character.toLowerCase(p.charAt(0)) + p.substring(1), value.toString());
                }
                SimpleHash model = new SimpleHash();
                model.put("properties", (Object)new MapModel(map, (BeansWrapper)this));
                model.put("className", (Object)this.clazz.getSimpleName());
                this.wrapInternal(map, model, object);
                return model;
            }
            return super.wrap(object);
        }

        protected void wrapInternal(Map properties, SimpleHash model, T object) {
        }
    }
}

