/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.format;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.geoserver.rest.format.StreamDataFormat;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;

public class MapJSONFormat
extends StreamDataFormat {
    public MapJSONFormat() {
        super(MediaType.APPLICATION_JSON);
    }

    protected void write(Object object, OutputStream out) throws IOException {
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(out));
        ((Writer)outWriter).flush();
        JSON obj = (JSON)this.toJSONObject(object);
        obj.write((Writer)outWriter);
        ((Writer)outWriter).flush();
    }

    public Object toJSONObject(Object obj) {
        if (obj instanceof Map) {
            Map m = (Map)obj;
            JSONObject json = new JSONObject();
            for (Map.Entry entry : m.entrySet()) {
                json.put((Object)((String)entry.getKey()), this.toJSONObject(entry.getValue()));
            }
            return json;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            JSONArray json = new JSONArray();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                json.add(this.toJSONObject(it.next()));
            }
            return json;
        }
        if (obj instanceof Number) {
            return obj;
        }
        if (obj == null) {
            return JSONNull.getInstance();
        }
        return obj.toString();
    }

    public Representation createRepresentation(Object data, Resource resource, Request request, Response response) {
        return null;
    }

    protected Object read(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder text = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            text.append(line);
        }
        return JSONObject.fromObject((Object)text.toString());
    }
}

