/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.rest.PageInfo;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MediaTypes;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource
extends Resource {
    protected Map<MediaType, DataFormat> formats;

    protected AbstractResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    protected AbstractResource() {
    }

    protected abstract List<DataFormat> createSupportedFormats(Request var1, Response var2);

    protected DataFormat getFormatGet() {
        MediaType mt;
        DataFormat df = null;
        String ext = (String)this.getRequest().getAttributes().get("format");
        if (ext == null) {
            ext = (String)this.getRequest().getAttributes().get("type");
        }
        if (ext == null) {
            String uri;
            String string = uri = this.getRequest().getResourceRef() != null ? this.getRequest().getResourceRef().getLastSegment() : null;
            if (uri != null) {
                ext = ResponseUtils.getExtension((String)uri);
            }
        }
        if (ext != null && (mt = MediaTypes.getMediaTypeForExtension(ext)) != null) {
            df = this.lookupFormat(mt);
        }
        ArrayList accepts = null;
        if (df == null) {
            accepts = new ArrayList(this.getRequest().getClientInfo().getAcceptedMediaTypes());
            Iterator i = accepts.iterator();
            while (i.hasNext()) {
                Preference pref = (Preference)i.next();
                if (((MediaType)pref.getMetadata()).equals((Object)MediaType.ALL)) {
                    i.remove();
                    continue;
                }
                df = this.lookupFormat((MediaType)pref.getMetadata());
                if (df == null) continue;
                break;
            }
        }
        if (df == null && accepts.isEmpty()) {
            df = this.getFormats().values().iterator().next();
        }
        return df;
    }

    protected DataFormat getFormatPostOrPut() {
        DataFormat format;
        MediaType type = this.getRequest().getEntity().getMediaType();
        if (type != null && (format = this.lookupFormat(type)) != null) {
            return format;
        }
        throw new RestletException("Could not determine format. Try setting the Content-type header.", Status.CLIENT_ERROR_BAD_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<MediaType, DataFormat> getFormats() {
        if (this.formats == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.formats == null) {
                    this.formats = new LinkedHashMap<MediaType, DataFormat>();
                    for (DataFormat format : this.createSupportedFormats(this.getRequest(), this.getResponse())) {
                        this.formats.put(format.getMediaType(), format);
                    }
                    if (this.formats.isEmpty()) {
                        throw new RuntimeException("Empty format list");
                    }
                }
            }
        }
        return this.formats;
    }

    DataFormat lookupFormat(MediaType mt) {
        DataFormat fmt = this.getFormats().get(mt);
        if (fmt == null) {
            for (MediaType mediaType : this.getFormats().keySet()) {
                if (!mediaType.includes(mt) && !mt.includes(mediaType)) continue;
                fmt = this.getFormats().get(mediaType);
                break;
            }
        }
        if (fmt == null) {
            for (MediaType syn : MediaTypes.getSynonyms(mt)) {
                fmt = this.getFormats().get(syn);
                if (fmt == null) continue;
                break;
            }
        }
        if (fmt == null) {
            for (MediaType mediaType : this.getFormats().keySet()) {
                for (MediaType syn : MediaTypes.getSynonyms(mediaType)) {
                    if (!mt.equals((Object)syn)) continue;
                    fmt = this.getFormats().get(mediaType);
                }
            }
        }
        if (fmt == null) {
            block4: for (MediaType syn : MediaTypes.getSynonyms(mt)) {
                for (MediaType mediaType : this.getFormats().keySet()) {
                    if (!mediaType.includes(syn) && !syn.includes(mediaType)) continue;
                    fmt = this.getFormats().get(mediaType);
                    continue block4;
                }
            }
        }
        return fmt;
    }

    protected PageInfo getPageInfo() {
        return (PageInfo)this.getRequest().getAttributes().get("org.geoserver.pageDetails");
    }

    static {
        MediaTypes.registerExtension("html", MediaType.TEXT_HTML);
        MediaTypes.registerExtension("xml", MediaType.APPLICATION_XML);
        MediaTypes.registerExtension("json", MediaType.APPLICATION_JSON);
        MediaTypes.registerSynonym(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
        MediaTypes.registerSynonym(MediaType.APPLICATION_JSON, new MediaType("text/json"));
    }
}

