/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.geotools.data.wfs.protocol.wfs.GetFeature;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.data.wfs.protocol.wfs.WFSProtocol;
import org.geotools.data.wfs.v1_1_0.DefaultWFSStrategy;
import org.geotools.data.wfs.v1_1_0.WFSStrategy;
import org.geotools.filter.Capabilities;
import org.geotools.filter.capability.FilterCapabilitiesImpl;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GMLBoxTypeBinding;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperator;
import org.opengis.filter.capability.SpatialOperators;
import org.picocontainer.MutablePicoContainer;

public class IonicStrategy
extends DefaultWFSStrategy {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private static final Configuration filter_1_0_0_Configuration = new OGCConfiguration(){

        protected void registerBindings(MutablePicoContainer container) {
            super.registerBindings(container);
            container.registerComponentImplementation((Object)GML.BoxType, IonicGML2BoxTypeBinding.class);
        }
    };

    public boolean supportsPost() {
        return false;
    }

    public String getDefaultOutputFormat(WFSProtocol wfs, WFSOperationType op) {
        if (WFSOperationType.GET_FEATURE != op) {
            throw new UnsupportedOperationException(String.valueOf((Object)op));
        }
        return "GML3";
    }

    protected Configuration getFilterConfiguration() {
        return filter_1_0_0_Configuration;
    }

    public WFSStrategy.RequestComponents createGetFeatureRequest(WFSProtocol wfs, GetFeature query) throws IOException {
        WFSStrategy.RequestComponents req = super.createGetFeatureRequest(wfs, query);
        GetFeatureType getFeature = req.getServerRequest();
        QueryType queryType = (QueryType)getFeature.getQuery().get(0);
        URI srsNameUri = queryType.getSrsName();
        String overrideSrs = "urn:opengis:def:crs:ogc::83";
        if (srsNameUri != null && srsNameUri.toString().equalsIgnoreCase("urn:opengis:def:crs:ogc::83")) {
            try {
                queryType.setSrsName(new URI("EPSG:4269"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("shouln't happen: " + e.getMessage());
            }
            Map<String, String> kvpParameters = req.getKvpParameters();
            kvpParameters.put("SRSNAME", "EPSG:4269");
        }
        return req;
    }

    public Filter[] splitFilters(Capabilities caps, Filter queryFilter) {
        SpatialOperator missnamedIntersects;
        SpatialOperators spatialOperators;
        FilterCapabilitiesImpl filterCapabilities = caps.getContents();
        SpatialCapabilities spatialCapabilities = filterCapabilities.getSpatialCapabilities();
        if (spatialCapabilities != null && (spatialOperators = spatialCapabilities.getSpatialOperators()) != null && (missnamedIntersects = spatialOperators.getOperator("Intersect")) != null) {
            LOGGER.fine("Ionic capabilities states the spatial operator Intersect. Assuming it is Intersects and adding Intersects as a supported filter type");
            caps.addName("Intersects");
        }
        return super.splitFilters(caps, queryFilter);
    }

    public static class IonicGML2BoxTypeBinding
    extends GMLBoxTypeBinding {
        public Object getProperty(Object object, QName name) throws Exception {
            Envelope e = (Envelope)object;
            if (GML.coordinates.equals(name)) {
                double[] seq = new double[]{e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY()};
                PackedCoordinateSequence.Double coords = new PackedCoordinateSequence.Double(seq, 2);
                return coords;
            }
            return null;
        }
    }
}

