/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.geotools.data.FeatureReader;
import org.geotools.data.wfs.v1_0_0.Action;
import org.geotools.data.wfs.v1_0_0.WFSTransactionState;
import org.geotools.xml.DocumentFactory;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.gml.FCBuffer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSFeatureReader
extends FCBuffer {
    private InputStream is = null;
    private WFSTransactionState ts = null;
    private SimpleFeature next = null;
    private int insertSearchIndex = -1;

    private WFSFeatureReader(InputStream is, int capacity, int timeout, WFSTransactionState trans, SimpleFeatureType ft) {
        super(null, capacity, timeout, ft);
        this.is = is;
        this.ts = trans;
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(URI document, int capacity, int timeout, WFSTransactionState transaction, SimpleFeatureType ft) throws SAXException {
        try {
            HttpURLConnection hc = (HttpURLConnection)document.toURL().openConnection();
            return WFSFeatureReader.getFeatureReader(hc.getInputStream(), capacity, timeout, transaction, ft);
        }
        catch (MalformedURLException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
        catch (IOException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
    }

    public static WFSFeatureReader getFeatureReader(InputStream is, int capacity, int timeout, WFSTransactionState transaction, SimpleFeatureType ft) throws SAXException {
        WFSFeatureReader fc = new WFSFeatureReader(is, capacity, timeout, transaction, ft);
        fc.start();
        if (fc.exception != null) {
            throw fc.exception;
        }
        return fc;
    }

    public void run() {
        XMLHandlerHints hints = new XMLHandlerHints();
        this.initHints(hints);
        try {
            try {
                DocumentFactory.getInstance((InputStream)this.is, (Map)hints, (Level)logger.getLevel());
                this.is.close();
            }
            catch (FCBuffer.StopException e) {
                this.exception = e;
                this.state = -2;
                this.is.close();
                WFSFeatureReader.yield();
            }
            catch (SAXException e) {
                this.exception = e;
                this.state = -2;
                this.is.close();
                WFSFeatureReader.yield();
            }
            catch (RuntimeException e) {
                this.exception = new SAXException(e.getMessage());
                this.exception.initCause(e);
                this.state = -2;
                this.is.close();
                WFSFeatureReader.yield();
            }
        }
        catch (IOException e) {
            logger.warning(e.toString());
        }
    }

    protected void initHints(XMLHandlerHints hints) {
        super.initHints(hints);
        HashMap<String, URI> schemas = new HashMap<String, URI>(1);
        SimpleFeatureType wfsFT = this.ft;
        String namespace = this.ft.getName().getNamespaceURI();
        try {
            URI uri = new URI(namespace);
            schemas.put(namespace, uri);
            hints.put((Object)"NAMESPACE_MAPPING", schemas);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        try {
            this.loadElement();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return this.next != null;
    }

    private boolean loadElement() throws NoSuchElementException, IOException {
        if (this.ts == null) {
            while (this.next == null && super.hasNext()) {
                this.next = super.next();
            }
        } else {
            List l = this.ts.getActions(this.ft.getTypeName());
            if (this.insertSearchIndex < l.size() && this.next == null) {
                while (this.insertSearchIndex + 1 < l.size() && this.next == null) {
                    ++this.insertSearchIndex;
                    Action a = (Action)l.get(this.insertSearchIndex);
                    if (a.getType() != 1) continue;
                    Action.InsertAction ia = (Action.InsertAction)a;
                    this.next = ia.getFeature();
                    for (int i = this.insertSearchIndex + 1; i < l.size() && this.next != null; ++i) {
                        a = (Action)l.get(i);
                        this.next = this.updateFeature(a, this.next);
                    }
                }
            }
            while (this.next == null && super.hasNext()) {
                this.next = super.next();
                if (this.ts == null || this.next == null) continue;
                Iterator i = l.iterator();
                while (i.hasNext() && this.next != null) {
                    Action a = (Action)i.next();
                    this.next = this.updateFeature(a, this.next);
                }
            }
        }
        return this.next != null;
    }

    private SimpleFeature updateFeature(Action a, SimpleFeature feature) {
        if (a.getType() == 4 && a.getFilter().evaluate((Object)feature)) {
            return null;
        }
        if (a.getType() == 2 && a.getFilter().evaluate((Object)feature)) {
            Action.UpdateAction ua = (Action.UpdateAction)a;
            ua.update(feature);
        }
        return feature;
    }

    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.next == null) {
            this.loadElement();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        SimpleFeature r = this.next;
        this.next = null;
        return r;
    }
}

