/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.wkt.Formatter;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGeocentricCRS
extends AbstractSingleCRS
implements GeocentricCRS {
    private static final long serialVersionUID = 6784642848287659827L;
    public static final DefaultGeocentricCRS CARTESIAN = new DefaultGeocentricCRS(DefaultGeocentricCRS.name(10), (GeodeticDatum)DefaultGeodeticDatum.WGS84, (CartesianCS)DefaultCartesianCS.GEOCENTRIC);
    public static final DefaultGeocentricCRS SPHERICAL = new DefaultGeocentricCRS(DefaultGeocentricCRS.name(220), (GeodeticDatum)DefaultGeodeticDatum.WGS84, (SphericalCS)DefaultSphericalCS.GEOCENTRIC);

    public DefaultGeocentricCRS(GeocentricCRS crs) {
        super((SingleCRS)crs);
    }

    public DefaultGeocentricCRS(String name, GeodeticDatum datum, CartesianCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeocentricCRS(String name, GeodeticDatum datum, SphericalCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, CartesianCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, SphericalCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    @Override
    public int hashCode() {
        return 0x54149733 ^ super.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        formatter.append((IdentifiedObject)this.datum);
        formatter.append((IdentifiedObject)((GeodeticDatum)this.datum).getPrimeMeridian());
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(GeocentricCRS.class);
        }
        return "GEOCCS";
    }
}

