/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.response.WFS10Response;
import org.opengis.filter.identity.FeatureId;
import org.vfny.geoserver.global.Data;

public class LockFeatureTypeResponse
extends WFS10Response {
    WFS wfs;
    Data catalog;

    public LockFeatureTypeResponse(WFS wfs, Data catalog) {
        super(LockFeatureResponseType.class);
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        FeatureId featureId;
        Iterator i;
        LockFeatureResponseType lockResponse = (LockFeatureResponseType)value;
        String indent = this.wfs.isVerbose() ? "   " : "";
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, this.wfs.getCharSet()));
        LockFeatureType lft = (LockFeatureType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)lft.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        writer.write("<?xml version=\"1.0\" encoding=\"" + this.wfs.getCharSet().name() + "\"?>");
        writer.write("<WFS_LockFeatureResponse \n");
        writer.write(indent + "xmlns=\"http://www.opengis.net/wfs\" " + "\n");
        writer.write(indent + "xmlns:ogc=\"http://www.opengis.net/ogc\" " + "\n");
        writer.write(indent + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "\n");
        writer.write(indent + "xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        writer.write(ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.0.0/WFS-transaction.xsd"));
        writer.write("\">\n");
        writer.write(indent + "<LockId>" + lockResponse.getLockId() + "</LockId>" + "\n");
        EList featuresLocked = null;
        if (lockResponse.getFeaturesLocked() != null) {
            featuresLocked = lockResponse.getFeaturesLocked().getFeatureId();
        }
        EList featuresNotLocked = null;
        if (lockResponse.getFeaturesNotLocked() != null) {
            featuresNotLocked = lockResponse.getFeaturesNotLocked().getFeatureId();
        }
        if (featuresLocked != null && !featuresLocked.isEmpty()) {
            writer.write(indent + "<FeaturesLocked>" + "\n");
            i = featuresLocked.iterator();
            while (i.hasNext()) {
                writer.write(indent + indent);
                featureId = (FeatureId)i.next();
                writer.write("<ogc:FeatureId fid=\"" + featureId + "\"/>" + "\n");
            }
            writer.write(indent + "</FeaturesLocked>" + "\n");
        }
        if (featuresNotLocked != null && !featuresNotLocked.isEmpty()) {
            writer.write("<FeaturesNotLocked>\n");
            i = featuresNotLocked.iterator();
            while (i.hasNext()) {
                writer.write(indent + indent);
                featureId = (FeatureId)i.next();
                writer.write("<ogc:FeatureId fid=\"" + featureId + "\"/>" + "\n");
            }
            writer.write("</FeaturesNotLocked>\n");
        }
        writer.write("</WFS_LockFeatureResponse>");
        writer.flush();
    }
}

