/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.NameSpaceInfo;

public class DescribeFeatureType {
    private Data catalog;
    private WFS wfs;

    public DescribeFeatureType(WFS wfs, Data catalog) {
        this.catalog = catalog;
        this.wfs = wfs;
    }

    public WFS getWFS() {
        return this.wfs;
    }

    public void setWFS(WFS wfs) {
        this.wfs = wfs;
    }

    public Data getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Data catalog) {
        this.catalog = catalog;
    }

    public FeatureTypeInfo[] run(DescribeFeatureTypeType request) throws WFSException {
        ArrayList names = new ArrayList(request.getTypeName());
        boolean citeConformance = this.getWFS().getCiteConformanceHacks();
        if (!citeConformance) {
            ArrayList<QName> hackedNames = new ArrayList<QName>(names.size());
            Data catalog = this.getWFS().getData();
            NameSpaceInfo defaultNameSpace = catalog.getDefaultNameSpace();
            if (defaultNameSpace == null) {
                throw new IllegalStateException("No default namespace configured in GeoServer");
            }
            String defaultNsUri = defaultNameSpace.getURI();
            for (QName name : names) {
                String nsUri = name.getNamespaceURI();
                if ("http://www.opengis.net/wfs".equals(nsUri)) {
                    name = new QName(defaultNsUri, name.getLocalPart(), name.getPrefix());
                }
                hackedNames.add(name);
            }
            names = hackedNames;
        }
        Collection infos = this.catalog.getFeatureTypeInfos().values();
        ArrayList<FeatureTypeInfo> requested = new ArrayList<FeatureTypeInfo>();
        if (!names.isEmpty()) {
            block1: for (QName name : names) {
                for (FeatureTypeInfo meta : infos) {
                    if (!meta.isEnabled()) continue;
                    String namespace = meta.getNameSpace().getURI();
                    String prefix = meta.getNameSpace().getPrefix();
                    String local = meta.getTypeName();
                    if (!local.equals(name.getLocalPart()) || !namespace.equals(name.getNamespaceURI()) && !prefix.equals(name.getPrefix())) continue;
                    requested.add(meta);
                    continue block1;
                }
                String msg = "Could not find type: " + name;
                if (citeConformance) {
                    msg = msg + ". \nStrict WFS protocol conformance is being applied.\nMake sure the type name is correctly qualified";
                }
                throw new WFSException(msg);
            }
        } else {
            for (FeatureTypeInfo ftInfo : infos) {
                if (!ftInfo.isEnabled()) continue;
                requested.add(ftInfo);
            }
        }
        return requested.toArray(new FeatureTypeInfo[requested.size()]);
    }
}

