/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.domain;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AuditableAcl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.OwnershipAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.UnloadedSidException;
import org.acegisecurity.acls.domain.AccessControlEntryImpl;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.domain.AuditLogger;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.springframework.util.Assert;

public class AclImpl
implements Acl,
MutableAcl,
AuditableAcl,
OwnershipAcl {
    private Acl parentAcl;
    private AclAuthorizationStrategy aclAuthorizationStrategy;
    private AuditLogger auditLogger;
    private List aces = new Vector();
    private ObjectIdentity objectIdentity;
    private Serializable id;
    private Sid owner;
    private Sid[] loadedSids = null;
    private boolean entriesInheriting = true;

    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)id, (String)"Id required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)auditLogger, (String)"AuditLogger required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.auditLogger = auditLogger;
    }

    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger, Acl parentAcl, Sid[] loadedSids, boolean entriesInheriting, Sid owner) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)id, (String)"Id required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)owner, (String)"Owner required");
        Assert.notNull((Object)auditLogger, (String)"AuditLogger required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.auditLogger = auditLogger;
        this.parentAcl = parentAcl;
        this.loadedSids = loadedSids;
        this.entriesInheriting = entriesInheriting;
        this.owner = owner;
    }

    private AclImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAce(Serializable aceId) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        List list = this.aces;
        synchronized (list) {
            int offset = this.findAceOffset(aceId);
            if (offset == -1) {
                throw new NotFoundException("Requested ACE ID not found");
            }
            this.aces.remove(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findAceOffset(Serializable aceId) {
        Assert.notNull((Object)aceId, (String)"ACE ID is required");
        List list = this.aces;
        synchronized (list) {
            for (int i = 0; i < this.aces.size(); ++i) {
                AccessControlEntry ace = (AccessControlEntry)this.aces.get(i);
                if (!ace.getId().equals(aceId)) continue;
                return i;
            }
        }
        return -1;
    }

    public AccessControlEntry[] getEntries() {
        return this.aces.toArray(new AccessControlEntry[0]);
    }

    public Serializable getId() {
        return this.id;
    }

    public ObjectIdentity getObjectIdentity() {
        return this.objectIdentity;
    }

    public Sid getOwner() {
        return this.owner;
    }

    public Acl getParentAcl() {
        return this.parentAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAce(Serializable afterAceId, Permission permission, Sid sid, boolean granting) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        Assert.notNull((Object)permission, (String)"Permission required");
        Assert.notNull((Object)sid, (String)"Sid required");
        AccessControlEntryImpl ace = new AccessControlEntryImpl(null, this, sid, permission, granting, false, false);
        List list = this.aces;
        synchronized (list) {
            if (afterAceId != null) {
                int offset = this.findAceOffset(afterAceId);
                if (offset == -1) {
                    throw new NotFoundException("Requested ACE ID not found");
                }
                this.aces.add(offset + 1, ace);
            } else {
                this.aces.add(ace);
            }
        }
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public boolean isGranted(Permission[] permission, Sid[] sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        Assert.notEmpty((Object[])permission, (String)"Permissions required");
        Assert.notEmpty((Object[])sids, (String)"SIDs required");
        if (!this.isSidLoaded(sids)) {
            throw new UnloadedSidException("ACL was not loaded for one or more SID");
        }
        AccessControlEntry firstRejection = null;
        block0: for (int i = 0; i < permission.length; ++i) {
            for (int x = 0; x < sids.length; ++x) {
                Iterator acesIterator = this.aces.iterator();
                boolean scanNextSid = true;
                while (acesIterator.hasNext()) {
                    AccessControlEntry ace = (AccessControlEntry)acesIterator.next();
                    if (ace.getPermission().getMask() != permission[i].getMask() || !((Object)ace.getSid()).equals(sids[x])) continue;
                    if (ace.isGranting()) {
                        if (!administrativeMode) {
                            this.auditLogger.logIfNeeded(true, ace);
                        }
                        return true;
                    }
                    if (firstRejection == null) {
                        firstRejection = ace;
                    }
                    scanNextSid = false;
                    break;
                }
                if (!scanNextSid) continue block0;
            }
        }
        if (firstRejection != null) {
            if (!administrativeMode) {
                this.auditLogger.logIfNeeded(false, firstRejection);
            }
            return false;
        }
        if (this.isEntriesInheriting() && this.parentAcl != null) {
            return this.parentAcl.isGranted(permission, sids, false);
        }
        throw new NotFoundException("Unable to locate a matching ACE for passed permissions and SIDs");
    }

    public boolean isSidLoaded(Sid[] sids) {
        if (this.loadedSids == null || sids == null || sids.length == 0) {
            return true;
        }
        for (int i = 0; i < sids.length; ++i) {
            boolean found = false;
            for (int y = 0; y < this.loadedSids.length; ++y) {
                if (!((Object)sids[i]).equals(this.loadedSids[y])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.entriesInheriting = entriesInheriting;
    }

    public void setOwner(Sid newOwner) {
        this.aclAuthorizationStrategy.securityCheck(this, 0);
        Assert.notNull((Object)newOwner, (String)"Owner required");
        this.owner = newOwner;
    }

    public void setParent(MutableAcl newParent) {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        Assert.notNull((Object)newParent, (String)"New Parent required");
        Assert.isTrue((!newParent.equals(this) ? 1 : 0) != 0, (String)"Cannot be the parent of yourself");
        this.parentAcl = newParent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AclImpl[");
        sb.append("id: ").append(this.id).append("; ");
        sb.append("objectIdentity: ").append(this.objectIdentity).append("; ");
        sb.append("owner: ").append(this.owner).append("; ");
        Iterator iterator = this.aces.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (++count == 1) {
                sb.append("\r\n");
            }
            sb.append(iterator.next().toString()).append("\r\n");
        }
        if (count == 0) {
            sb.append("no ACEs; ");
        }
        sb.append("inheriting: ").append(this.entriesInheriting).append("; ");
        sb.append("parent: ").append(this.parentAcl == null ? "Null" : this.parentAcl.getObjectIdentity().toString());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAce(Serializable aceId, Permission permission) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        List list = this.aces;
        synchronized (list) {
            int offset = this.findAceOffset(aceId);
            if (offset == 1) {
                throw new NotFoundException("Requested ACE ID not found");
            }
            AccessControlEntryImpl ace = (AccessControlEntryImpl)this.aces.get(offset);
            ace.setPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuditing(Serializable aceId, boolean auditSuccess, boolean auditFailure) {
        this.aclAuthorizationStrategy.securityCheck(this, 1);
        List list = this.aces;
        synchronized (list) {
            int offset = this.findAceOffset(aceId);
            if (offset == 1) {
                throw new NotFoundException("Requested ACE ID not found");
            }
            AccessControlEntryImpl ace = (AccessControlEntryImpl)this.aces.get(offset);
            ace.setAuditSuccess(auditSuccess);
            ace.setAuditFailure(auditFailure);
        }
    }
}

