/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class NodataFilter
extends AreaOpImage {
    private static double[] sharedDistances;
    private final double[] distances;
    private final int validityThreshold;

    protected NodataFilter(RenderedImage source, ImageLayout layout, Map map, int padding, int validityThreshold) {
        super(source, layout, map, false, null, padding, padding, padding, padding);
        this.validityThreshold = validityThreshold;
        if (padding == 1 && sharedDistances != null) {
            this.distances = sharedDistances;
        } else {
            this.distances = new double[(this.leftPadding + this.rightPadding + 1) * (this.topPadding + this.bottomPadding + 1)];
            int index = 0;
            for (int dy = -this.topPadding; dy <= this.bottomPadding; ++dy) {
                for (int dx = -this.leftPadding; dx <= this.rightPadding; ++dx) {
                    this.distances[index++] = Math.sqrt(dx * dx + dy * dy);
                }
            }
            assert (index == this.distances.length);
            if (padding == 1) {
                sharedDistances = this.distances;
            }
        }
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        assert (sources.length == 1);
        PlanarImage source = sources[0];
        Rectangle sourceRect = this.mapDestRect(destRect, 0);
        sourceRect = sourceRect.intersection(source.getBounds());
        RandomIter iter = RandomIterFactory.create((RenderedImage)source, (Rectangle)sourceRect);
        int minX = destRect.x;
        int minY = destRect.y;
        int maxX = destRect.width + minX;
        int maxY = destRect.height + minY;
        int hPad = this.leftPadding + this.rightPadding + 1;
        int band = source.getNumBands();
        while (--band >= 0) {
            for (int y = minY; y < maxY; ++y) {
                int minScanY = Math.max(minY, y - this.topPadding);
                int maxScanY = Math.min(maxY, y + this.bottomPadding + 1);
                int minScanI = (minScanY - (y - this.topPadding)) * hPad;
                assert (minScanI >= 0 && minScanI <= this.distances.length) : minScanI;
                for (int x = minX; x < maxX; ++x) {
                    double current = iter.getSampleDouble(x, y, band);
                    if (!Double.isNaN(current)) {
                        dest.setSample(x, y, band, current);
                        continue;
                    }
                    int count = 0;
                    double sumValue = 0.0;
                    double sumDistance = 0.0;
                    int minScanX = Math.max(minX, x - this.leftPadding);
                    int maxScanX = Math.min(maxX, x + this.rightPadding + 1);
                    int lineOffset = hPad - (maxScanX - minScanX);
                    int index = minScanI + (minScanX - (x - this.leftPadding));
                    for (int sy = minScanY; sy < maxScanY; ++sy) {
                        for (int sx = minScanX; sx < maxScanX; ++sx) {
                            double scan = iter.getSampleDouble(sx, sy, band);
                            if (!Double.isNaN(scan)) {
                                double distance = this.distances[index];
                                assert (Math.abs(distance - Math.hypot(sx - x, sy - y)) < 1.0E-6 && distance > 0.0) : distance;
                                sumValue += distance * scan;
                                sumDistance += distance;
                                ++count;
                            }
                            ++index;
                        }
                        index += lineOffset;
                    }
                    dest.setSample(x, y, band, count >= this.validityThreshold ? sumValue / sumDistance : current);
                }
            }
        }
        iter.done();
    }
}

