/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.coverage.processing.CachedOperation;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.util.WeakValueHashMap;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class BufferedProcessor
extends AbstractProcessor {
    protected final AbstractProcessor processor;
    private transient Map cache;

    public BufferedProcessor(RenderingHints hints) {
        DefaultProcessor processor = new DefaultProcessor(hints);
        processor.setProcessor(this);
        this.processor = processor;
    }

    public BufferedProcessor(AbstractProcessor processor) {
        BufferedProcessor.ensureNonNull("processor", processor);
        this.processor = processor;
    }

    void setAsDefault() {
        this.processor.setAsDefault();
    }

    public Collection getOperations() {
        return this.processor.getOperations();
    }

    public Operation getOperation(String name) throws OperationNotFoundException {
        return this.processor.getOperation(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coverage doOperation(ParameterValueGroup parameters) throws OperationNotFoundException {
        AbstractProcessor abstractProcessor = this.processor;
        synchronized (abstractProcessor) {
            RenderedImage image;
            Coverage coverage;
            String operationName = BufferedProcessor.getOperationName(parameters);
            Operation operation = this.processor.getOperation(operationName);
            CachedOperation cacheKey = new CachedOperation(operation, parameters);
            if (this.cache != null) {
                coverage = (Coverage)this.cache.get(cacheKey);
                if (coverage != null) {
                    this.log(BufferedProcessor.getPrimarySource(parameters), coverage, operationName, true);
                    return coverage;
                }
            } else {
                this.cache = new WeakValueHashMap();
            }
            if ((coverage = this.processor.doOperation(parameters)) instanceof RenderedCoverage && (image = ((RenderedCoverage)coverage).getRenderedImage()) instanceof PlanarImage) {
                ((PlanarImage)image).addSink((Object)cacheKey);
            }
            this.cache.put(cacheKey, coverage);
            return coverage;
        }
    }
}

