/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GeometryCombiner {
    private GeometryFactory geomFactory;
    private boolean skipEmpty = false;
    private Collection inputGeoms;

    public static Geometry combine(Collection geoms) {
        GeometryCombiner combiner = new GeometryCombiner(geoms);
        return combiner.combine();
    }

    public static Geometry combine(Geometry g0, Geometry g1) {
        GeometryCombiner combiner = new GeometryCombiner(GeometryCombiner.createList(g0, g1));
        return combiner.combine();
    }

    public static Geometry combine(Geometry g0, Geometry g1, Geometry g2) {
        GeometryCombiner combiner = new GeometryCombiner(GeometryCombiner.createList(g0, g1, g2));
        return combiner.combine();
    }

    public GeometryCombiner(Collection geoms) {
        this.geomFactory = GeometryCombiner.extractFactory(geoms);
        this.inputGeoms = geoms;
    }

    private static List createList(Object obj0, Object obj1) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(obj0);
        list.add(obj1);
        return list;
    }

    private static List createList(Object obj0, Object obj1, Object obj2) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(obj0);
        list.add(obj1);
        list.add(obj2);
        return list;
    }

    public static GeometryFactory extractFactory(Collection geoms) {
        if (geoms.isEmpty()) {
            return null;
        }
        return ((Geometry)geoms.iterator().next()).getFactory();
    }

    public Geometry combine() {
        ArrayList elems = new ArrayList();
        Iterator i = this.inputGeoms.iterator();
        while (i.hasNext()) {
            Geometry g = (Geometry)i.next();
            this.extractElements(g, elems);
        }
        if (elems.size() == 0) {
            if (this.geomFactory != null) {
                return this.geomFactory.createGeometryCollection(null);
            }
            return null;
        }
        return this.geomFactory.buildGeometry(elems);
    }

    private void extractElements(Geometry geom, List elems) {
        if (geom == null) {
            return;
        }
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry elemGeom = geom.getGeometryN(i);
            if (this.skipEmpty && elemGeom.isEmpty()) continue;
            elems.add(elemGeom);
        }
    }
}

