/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util.wms;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BBOX {
    private static Log log = LogFactory.getLog(BBOX.class);
    private static String DELIMITER = ",";
    private static double EQUALITYTHRESHOLD = 0.03;
    public static final BBOX WORLD4326 = new BBOX(-180.0, -90.0, 180.0, 90.0);
    public static final BBOX WORLD900913 = new BBOX(-2.003750834E7, -2.003750834E7, 2.003750834E7, 2.003750834E7);
    public double[] coords = new double[4];

    public BBOX(BBOX bbox) {
        this.coords[0] = bbox.coords[0];
        this.coords[1] = bbox.coords[1];
        this.coords[2] = bbox.coords[2];
        this.coords[3] = bbox.coords[3];
    }

    public BBOX(String BBOX2) {
        this.setFromBBOXString(BBOX2, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public BBOX(String[] BBOX2) {
        this.setFromStringArray(BBOX2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public BBOX(double minx, double miny, double maxx, double maxy) {
        this.coords[0] = minx;
        this.coords[1] = miny;
        this.coords[2] = maxx;
        this.coords[3] = maxy;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created BBOX: " + this.getReadableString()));
        }
    }

    public void setFromStringArray(String[] BBOX2) {
        this.setFromStringArray(BBOX2, 0);
    }

    public void setFromStringArray(String[] BBOX2, int recWatch) {
        if (BBOX2.length == 4) {
            this.coords[0] = Double.valueOf(BBOX2[0]);
            this.coords[1] = Double.valueOf(BBOX2[1]);
            this.coords[2] = Double.valueOf(BBOX2[2]);
            this.coords[3] = Double.valueOf(BBOX2[3]);
        } else if (recWatch < 4) {
            this.setFromBBOXString(BBOX2[0], recWatch);
        } else {
            log.error((Object)("Doesnt understand " + Arrays.toString(BBOX2)));
        }
    }

    public void setFromBBOXString(String BBOX2, int recWatch) {
        String[] tokens = BBOX2.split(DELIMITER);
        this.setFromStringArray(tokens, recWatch + 1);
    }

    public String getReadableString() {
        return "Min X: " + this.coords[0] + " Min Y: " + this.coords[1] + " Max X: " + this.coords[2] + " Max Y: " + this.coords[3];
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(40);
        buff.append(Double.toString(this.coords[0]));
        buff.append(',');
        buff.append(Double.toString(this.coords[1]));
        buff.append(',');
        buff.append(Double.toString(this.coords[2]));
        buff.append(',');
        buff.append(Double.toString(this.coords[3]));
        return buff.toString();
    }

    public String toKML() {
        return "<LatLonAltBox><north>" + Double.toString(this.coords[3]) + "</north>" + "<south>" + Double.toString(this.coords[1]) + "</south>" + "<east>" + Double.toString(this.coords[2]) + "</east>" + "<west>" + Double.toString(this.coords[0]) + "</west>" + "</LatLonAltBox>";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            BBOX other = (BBOX)obj;
            boolean result = true;
            for (int i = 0; i < 4 && result; ++i) {
                result = Math.abs(this.coords[i]) < EQUALITYTHRESHOLD && Math.abs(other.coords[i]) < EQUALITYTHRESHOLD || (this.coords[i] - other.coords[i]) / (this.coords[i] + other.coords[i]) < EQUALITYTHRESHOLD;
            }
            return result;
        }
        return false;
    }

    public boolean contains(BBOX other) {
        return this.coords[0] - EQUALITYTHRESHOLD <= other.coords[0] && this.coords[1] - EQUALITYTHRESHOLD <= other.coords[1] && this.coords[2] + EQUALITYTHRESHOLD >= other.coords[2] && this.coords[3] + EQUALITYTHRESHOLD >= other.coords[3];
    }

    public boolean isSane() {
        return this.coords[0] < this.coords[2] && this.coords[1] < this.coords[3];
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.coords[0]) ^ Float.floatToIntBits((float)this.coords[2]);
    }

    public static BBOX intersection(BBOX bboxA, BBOX bboxB) {
        int i;
        BBOX retBbox = new BBOX(0.0, 0.0, 0.0, 0.0);
        for (i = 0; i < 2; ++i) {
            retBbox.coords[i] = bboxA.coords[i] > bboxB.coords[i] ? bboxA.coords[i] : bboxB.coords[i];
        }
        for (i = 2; i < 4; ++i) {
            retBbox.coords[i] = bboxA.coords[i] < bboxB.coords[i] ? bboxA.coords[i] : bboxB.coords[i];
        }
        return retBbox;
    }

    public void scale(double factor) {
        double x = this.coords[2] - this.coords[0];
        double xdiff = (x * factor - x) / 2.0;
        double y = this.coords[3] - this.coords[1];
        double ydiff = (y * factor - y) / 2.0;
        this.coords[0] = this.coords[0] - xdiff;
        this.coords[1] = this.coords[1] - ydiff;
        this.coords[2] = this.coords[2] + xdiff;
        this.coords[3] = this.coords[3] + ydiff;
    }
}

