/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtils {
    private static Log log = LogFactory.getLog(ServletUtils.class);
    private static Calendar calendar = new GregorianCalendar();
    private static TimeZone timeZone = TimeZone.getTimeZone("GMT");
    private static SimpleDateFormat format = null;
    private static long localOffset = TimeZone.getDefault().getRawOffset();

    public static String[] stringsFromMap(Map<String, String[]> map, String key) {
        String[] strArray = map.get(key);
        if (strArray != null) {
            return strArray;
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String stringFromMap(Map<String, String[]> map, String key) {
        String[] strArray = ServletUtils.stringsFromMap(map, key);
        if (strArray != null) {
            return strArray[0];
        }
        return null;
    }

    public static String[][] selectedStringArraysFromMap(Map<String, String[]> map, String[] keys) {
        String[][] retAr = new String[keys.length][];
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equalsIgnoreCase(keys[i])) continue;
                retAr[i] = entry.getValue();
            }
        }
        return retAr;
    }

    public static String[] selectedStringsFromMap(Map<String, String[]> map, String[] keys) {
        String[] retAr = new String[keys.length];
        block0: for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equalsIgnoreCase(keys[i])) continue;
                retAr[i] = entry.getValue()[0];
                continue block0;
            }
        }
        return retAr;
    }

    public static byte[] readStream(InputStream is, int bufferHint, int tmpBufferSize) throws IOException {
        byte[] buffer = null;
        buffer = bufferHint > 0 ? new byte[bufferHint] : new byte[10240];
        byte[] tmpBuffer = null;
        tmpBuffer = tmpBufferSize > 0 ? new byte[tmpBufferSize] : new byte[1024];
        int totalCount = 0;
        int c = 0;
        while (c != -1) {
            if (totalCount + c >= buffer.length) {
                int newLength = buffer.length * 2;
                if (newLength < totalCount) {
                    newLength = totalCount;
                }
                byte[] newBuffer = new byte[newLength];
                System.arraycopy(buffer, 0, newBuffer, 0, totalCount);
                buffer = newBuffer;
            }
            System.arraycopy(tmpBuffer, 0, buffer, totalCount, c);
            totalCount += c;
            c = is.read(tmpBuffer);
        }
        is.close();
        byte[] newBuffer = new byte[totalCount];
        System.arraycopy(buffer, 0, newBuffer, 0, totalCount);
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeExpiresHeader(int seconds) {
        String ret;
        Calendar calendar = ServletUtils.calendar;
        synchronized (calendar) {
            if (format == null) {
                format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(timeZone);
            }
            ServletUtils.calendar.setTimeInMillis(System.currentTimeMillis() + (long)(seconds * 1000));
            ret = format.format(ServletUtils.calendar.getTime());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseExpiresHeader(String expiresHeader) {
        long ret;
        if (expiresHeader == null) {
            return -1L;
        }
        Calendar calendar = ServletUtils.calendar;
        synchronized (calendar) {
            if (format == null) {
                format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(timeZone);
            }
            try {
                format.parse(expiresHeader);
            }
            catch (ParseException pe) {
                log.debug((Object)("Cannot parse " + expiresHeader + ", " + pe.getMessage()));
                return -1L;
            }
            ret = ServletUtils.calendar.getTimeInMillis() - System.currentTimeMillis() - localOffset;
        }
        return ret;
    }

    public static String hexOfBytes(byte[] bytes) {
        StringBuilder str = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            str.append(ServletUtils.hexOfByte(bytes[i]));
        }
        return str.toString();
    }

    public static String hexOfByte(byte aByte) {
        String out = "";
        for (int i = 0; i < 2; ++i) {
            int temp = aByte;
            if (temp < 0) {
                temp += 256;
            }
            temp = i == 0 ? (temp /= 16) : (temp %= 16);
            if (temp > 9) {
                switch (temp) {
                    case 10: {
                        out = out + "A";
                        break;
                    }
                    case 11: {
                        out = out + "B";
                        break;
                    }
                    case 12: {
                        out = out + "C";
                        break;
                    }
                    case 13: {
                        out = out + "D";
                        break;
                    }
                    case 14: {
                        out = out + "E";
                        break;
                    }
                    case 15: {
                        out = out + "F";
                    }
                }
                continue;
            }
            out = out + Integer.toString(temp);
        }
        return out;
    }
}

