/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.WFSObject;
import org.geowebcache.storage.metastore.jdbc.JDBCMBIdCache;
import org.geowebcache.storage.metastore.jdbc.JDBCMBWrapper;

public class JDBCMetaBackend
implements MetaStore {
    private static Log log = LogFactory.getLog(JDBCMetaBackend.class);
    private final JDBCMBWrapper wrpr;
    private final JDBCMBIdCache idCache;

    public JDBCMetaBackend(String driverClass, String jdbcString, String username, String password) throws StorageException {
        try {
            this.wrpr = new JDBCMBWrapper(driverClass, jdbcString, username, password);
        }
        catch (SQLException se) {
            throw new StorageException(se.getMessage());
        }
        this.idCache = new JDBCMBIdCache(this.wrpr);
    }

    public JDBCMetaBackend(DefaultStorageFinder defStoreFind) throws StorageException {
        try {
            this.wrpr = new JDBCMBWrapper(defStoreFind);
        }
        catch (SQLException se) {
            throw new StorageException(se.getMessage());
        }
        this.idCache = new JDBCMBIdCache(this.wrpr);
    }

    public boolean get(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        }
        try {
            return this.wrpr.getTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get tile: " + se.getMessage()));
            return false;
        }
    }

    public boolean get(WFSObject stObj) throws StorageException {
        Long parameters_id = null;
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            parameters_id = this.idCache.getParametersId(stObj.getParameters());
        }
        try {
            return this.wrpr.getWFS(parameters_id, stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get WFS object: " + se.getMessage()));
            return false;
        }
    }

    public void put(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        }
        try {
            this.wrpr.putTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to put tile: " + se.getMessage()));
        }
    }

    public void put(WFSObject stObj) throws StorageException {
        Long parameters_id = null;
        if (stObj.getParameters() != null && stObj.getParameters().length() != 0) {
            parameters_id = this.idCache.getParametersId(stObj.getParameters());
        }
        try {
            this.wrpr.putWFS(parameters_id, stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to put WFS object: " + se.getMessage()));
        }
    }

    public void delete(WFSObject stObj) {
    }

    public void delete(TileObject stObj) {
    }

    public void clear() throws StorageException {
        if (this.wrpr.driverClass.equals("org.h2.Driver")) {
            throw new StorageException("clear() has not been implemented for " + this.wrpr.driverClass);
        }
    }

    public void destroy() {
        if (this.wrpr != null) {
            this.wrpr.destroy();
        }
    }
}

