/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorKMLTile;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.kml.KMLService;
import org.geowebcache.service.kml.KMZHelper;
import org.geowebcache.storage.StorageBroker;

public class KMLSiteMap {
    private ConveyorKMLTile tile = null;
    private TileLayerDispatcher tLD = null;
    private StorageBroker storageBroker;

    public KMLSiteMap(ConveyorKMLTile tile, TileLayerDispatcher tLD) {
        this.tile = tile;
        this.tLD = tLD;
        this.storageBroker = tile.getStorageBroker();
    }

    public void write() throws GeoWebCacheException, IOException {
        this.tile.servletResp.setCharacterEncoding("utf-8");
        this.tile.servletResp.setContentType("application/xml");
        this.tile.servletResp.setStatus(200);
        if (this.tile.getHint() == "sitemap") {
            this.writeSiteMap();
        } else {
            this.writeSiteMapIndex();
        }
    }

    private void writeSiteMapIndex() throws IOException {
        ServletOutputStream os = this.tile.servletResp.getOutputStream();
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
        os.write(header.getBytes());
        this.writeSiteMapIndexLoop();
        String footer = "</sitemapindex>";
        os.write(footer.getBytes());
    }

    private void writeSiteMapIndexLoop() throws IOException {
        ServletOutputStream os = this.tile.servletResp.getOutputStream();
        String urlPrefix = this.tile.getUrlPrefix();
        for (TileLayer tl : this.tLD.getLayers().values()) {
            tl.isInitialized();
            Hashtable<SRS, Grid> grids = tl.getGrids();
            List<MimeType> mimeTypes = tl.getMimeTypes();
            if (grids == null || !grids.containsKey(SRS.getEPSG4326()) || mimeTypes == null || !mimeTypes.contains(XMLMime.kml)) continue;
            String smStr = "<sitemap><loc>" + urlPrefix + tl.getName() + "/sitemap.xml</loc></sitemap>";
            os.write(smStr.getBytes());
        }
    }

    private void writeSiteMap() throws GeoWebCacheException, IOException {
        TileLayer layer = this.tile.getLayer();
        this.writeSiteMapHeader();
        int[] gridLoc = layer.getZoomedOutGridLoc(SRS.getEPSG4326());
        if (gridLoc[2] < 0) {
            int[] gridLocWest = new int[]{0, 0, 0};
            int[] gridLocEast = new int[]{1, 0, 0};
            this.writeSiteMapLoop(gridLocWest);
            this.writeSiteMapLoop(gridLocEast);
        } else {
            this.writeSiteMapLoop(gridLoc);
        }
        this.writeSiteMapFooter();
    }

    private void writeSiteMapHeader() throws IOException {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:geo=\"http://www.google.com/geo/schemas/sitemap/1.0\">\n";
        this.tile.servletResp.getOutputStream().write(header.getBytes());
    }

    private void writeSiteMapFooter() throws IOException {
        String footer = "</urlset>";
        this.tile.servletResp.getOutputStream().write(footer.getBytes());
    }

    public void writeSiteMapLoop(int[] gridLoc) throws GeoWebCacheException, IOException {
        ServletOutputStream os = this.tile.servletResp.getOutputStream();
        SRS srs = SRS.getEPSG4326();
        TileLayer tileLayer = this.tile.getLayer();
        String urlPrefix = this.tile.getUrlPrefix();
        String superOverlayLoc = "<url><loc>" + urlPrefix.substring(0, urlPrefix.length() - 1) + ".kml.kml</loc><geo:geo><geo:format>kml</geo:format></geo:geo></url>\n";
        os.write(superOverlayLoc.getBytes());
        LinkedList<int[]> subTileList = new LinkedList<int[]>();
        subTileList.addFirst(gridLoc);
        while (subTileList.peek() != null) {
            int[] curLoc = (int[])subTileList.removeFirst();
            int[][] linkGridLocs = tileLayer.getZoomInGridLoc(srs, curLoc);
            for (int[] subTile : linkGridLocs = KMZHelper.filterGridLocs(this.storageBroker, tileLayer, XMLMime.kml, linkGridLocs)) {
                if (subTile[2] <= 0) continue;
                subTileList.addLast(subTile);
            }
            String tmp = "<url><loc>" + urlPrefix + KMLService.gridLocString(curLoc) + ".kml" + "</loc><geo:geo><geo:format>kml</geo:format></geo:geo></url>\n";
            os.write(tmp.getBytes());
        }
    }
}

