/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorKMLTile;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.conveyor.ConveyorWFS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.service.ServiceException;
import org.geowebcache.util.ServletUtils;

public abstract class Service {
    private String pathName = null;

    public Service(String pathName) {
        this.pathName = pathName;
    }

    public boolean handlesRequest(HttpServletRequest request) {
        return request.getPathInfo().equalsIgnoreCase(this.pathName);
    }

    public String getPathName() {
        return this.pathName;
    }

    public Conveyor getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        throw new ServiceException("Service for " + this.pathName + " needs to override " + "getConveyor(HttpSerlvetRequest,HttpServletResponse)");
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        throw new RuntimeException("Service for " + this.pathName + " needs to override " + "handleRequest(TileLayerDispatcher, Tile)");
    }

    protected String getLayersParameter(HttpServletRequest request) throws ServiceException {
        String layers = ServletUtils.stringFromMap(request.getParameterMap(), "layers");
        if (layers == null) {
            throw new ServiceException("Unable to parse layers parameter from request.");
        }
        return layers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Service) {
            Service other = (Service)obj;
            if (other.pathName != null && other.pathName.equalsIgnoreCase(this.pathName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.pathName.hashCode();
    }

    protected static void writeTileResponse(ConveyorTile conv, boolean writeExpiration) {
        ConveyorKMLTile kmlTile;
        HttpServletResponse response = conv.servletResp;
        byte[] data = conv.getContent();
        String mimeStr = conv.getMimeType().getMimeType();
        response.setCharacterEncoding("utf-8");
        if (conv instanceof ConveyorTile) {
            ConveyorTile tile = conv;
            response.setStatus(tile.getStatus());
            TileLayer layer = tile.getLayer();
            if (layer != null) {
                layer.setExpirationHeader(conv.servletResp);
            }
            if (writeExpiration) {
                tile.getLayer().setExpirationHeader(response);
            }
        }
        if (conv instanceof ConveyorKMLTile && (kmlTile = (ConveyorKMLTile)conv).getWrapperMimeType() != null) {
            mimeStr = kmlTile.getWrapperMimeType().getMimeType();
        }
        response.setContentType(mimeStr);
        response.setContentLength(data.length);
        try {
            ServletOutputStream os = response.getOutputStream();
            os.write(data);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeWFSResponse(ConveyorWFS conv, boolean writeExpiration) {
        HttpServletResponse response = conv.servletResp;
        String mimeStr = conv.getMimeTypeString();
        response.setCharacterEncoding("utf-8");
        response.setContentType(mimeStr);
        InputStream is = null;
        ServletOutputStream os = null;
        try {
            is = conv.getInputStream();
            os = response.getOutputStream();
            byte[] buffer = new byte[2048];
            int read = 0;
            while (read != -1) {
                read = is.read(buffer);
                if (read == -1) continue;
                os.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

