/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.util.wms.BBOX;

public abstract class Parameters {
    private static Log log = LogFactory.getLog(Parameters.class);
    protected static final String CHARSET = "UTF-8";
    protected Map params = new HashMap();

    public Parameters() {
    }

    public Parameters(HttpServletRequest httprequest) {
        this.setFromHttpServletRequest(httprequest);
    }

    public void setFromHttpServletRequest(HttpServletRequest httprequest) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Setting from HttpServletRequest.");
        }
        for (Map.Entry ent : httprequest.getParameterMap().entrySet()) {
            this.params.put(((String)ent.getKey()).toLowerCase(), ent.getValue());
        }
    }

    public void set(String key, Object value) {
        this.params.put(key.toLowerCase(), value);
    }

    public Object get(String key) {
        return this.params.get(key.toLowerCase());
    }

    public void remove(String key) {
        this.params.remove(key.toLowerCase());
    }

    protected String convertToString(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Boolean) {
                return ((Boolean)obj).toString().toUpperCase();
            }
            if (obj instanceof String[]) {
                String[] array = (String[])obj;
                StringBuffer str = new StringBuffer(100);
                boolean notfirst = false;
                for (int i = 0; i < array.length; ++i) {
                    if (notfirst) {
                        str.append(',');
                    } else {
                        notfirst = true;
                    }
                    str.append(array[i]);
                }
                return str.toString();
            }
            return obj.toString();
        }
        return null;
    }

    public void merge(Parameters params) {
        this.params.putAll(params.params);
    }

    public abstract String getLayer();

    public abstract BBOX getBBOX();
}

