/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class ImageMime
extends MimeType {
    private static Log log = LogFactory.getLog(ImageMime.class);
    public static final ImageMime png = new ImageMime("image/png", "png", "png", "image/png", true);
    public static final ImageMime jpeg = new ImageMime("image/jpeg", "jpeg", "jpeg", "image/jpeg", true);
    public static final ImageMime gif = new ImageMime("image/gif", "gif", "gif", "image/gif", true);
    public static final ImageMime tiff = new ImageMime("image/tiff", "tiff", "tiff", "image/tiff", true);
    public static final ImageMime png8 = new ImageMime("image/png", "png8", "png", "image/png8", true);
    public static final ImageMime png24 = new ImageMime("image/png", "png24", "png", "image/png24", true);
    public static final ImageMime png_24 = new ImageMime("image/png; mode=24bit", "png_24", "png", "image/png; mode=24bit", true);

    public ImageMime(String mimeType, String fileExtension, String internalName, String format, boolean noop) {
        super(mimeType, fileExtension, internalName, format, true);
    }

    public ImageMime(String mimeType, String fileExtension, String internalName, String format) throws MimeException {
        super(mimeType, fileExtension, internalName, format, true);
        if (mimeType.length() < 6 || !mimeType.substring(0, 6).equalsIgnoreCase("image/")) {
            throw new MimeException("MIME type " + mimeType + " does not start with image/");
        }
    }

    protected static ImageMime checkForFormat(String formatStr) throws MimeException {
        String tmpStr = formatStr.substring(6, formatStr.length());
        if (tmpStr.equalsIgnoreCase("png")) {
            return png;
        }
        if (tmpStr.equalsIgnoreCase("jpeg")) {
            return jpeg;
        }
        if (tmpStr.equalsIgnoreCase("gif")) {
            return gif;
        }
        if (tmpStr.equalsIgnoreCase("tiff")) {
            return tiff;
        }
        if (tmpStr.equalsIgnoreCase("png8")) {
            return png8;
        }
        if (tmpStr.equalsIgnoreCase("png24")) {
            return png24;
        }
        if (tmpStr.equalsIgnoreCase("png; mode=24bit")) {
            return png_24;
        }
        return null;
    }

    protected static ImageMime checkForExtension(String fileExtension) throws MimeException {
        if (fileExtension.equalsIgnoreCase("png")) {
            return png;
        }
        if (fileExtension.equalsIgnoreCase("jpeg")) {
            return jpeg;
        }
        if (fileExtension.equalsIgnoreCase("gif")) {
            return gif;
        }
        if (fileExtension.equalsIgnoreCase("tiff")) {
            return tiff;
        }
        if (fileExtension.equalsIgnoreCase("png8")) {
            return png8;
        }
        if (fileExtension.equalsIgnoreCase("png24")) {
            return png24;
        }
        if (fileExtension.equalsIgnoreCase("png_24")) {
            return png_24;
        }
        return null;
    }
}

