/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.ParameterFilter;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.GridLocObj;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.mime.ErrorMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.TileObject;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.wms.BBOX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayer
extends TileLayer {
    private String[] wmsUrl = null;
    private String wmsLayers = null;
    private String wmsStyles = null;
    private int[] metaWidthHeight = null;
    private String errorMime;
    private String wmsVersion;
    private Boolean tiled;
    private Boolean transparent;
    private String bgColor;
    private String palette;
    private String vendorParameters;
    private String cachePrefix;
    private String expireCache;
    private String expireClients;
    protected Integer backendTimeout;
    protected Boolean cacheBypassAllowed;
    protected List<ParameterFilter> parameterFilters;
    private transient int expireCacheInt = -1;
    private transient int expireClientsInt = -1;
    private transient int curWmsURL;
    private transient boolean saveExpirationHeaders;
    private transient Lock layerLock;
    private transient boolean layerLocked;
    private transient Condition layerLockedCond;
    private transient Condition[] gridLocConds;
    private transient List<MimeType> formats;
    private transient HashMap<GridLocObj, Boolean> procQueue;
    private transient ParameterFilter[] sortedModParams;
    private transient String[] sortedModParamsKeys;
    private transient boolean stylesIsModParam = false;
    private volatile transient Boolean isInitialized;
    private static transient Log log;

    public WMSLayer(String layerName, String[] wmsURL, String wmsStyles, String wmsLayers, List<String> mimeFormats, Hashtable<SRS, Grid> grids, int[] metaWidthHeight, String vendorParams) {
        this.name = layerName;
        this.wmsUrl = wmsURL;
        this.wmsLayers = wmsLayers;
        this.wmsStyles = wmsStyles;
        this.mimeFormats = mimeFormats;
        this.grids = grids;
        this.metaWidthHeight = metaWidthHeight;
        this.expireClientsInt = -4;
        this.expireCacheInt = -2;
        this.vendorParameters = vendorParams;
        this.transparent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isInitialized() {
        Boolean result = this.isInitialized;
        if (result == null) {
            WMSLayer wMSLayer = this;
            synchronized (wMSLayer) {
                result = this.isInitialized;
                if (result == null) {
                    this.isInitialized = result = this.initialize();
                }
            }
        }
        return result;
    }

    @Override
    protected Boolean initialize() {
        log = LogFactory.getLog(WMSLayer.class);
        this.curWmsURL = 0;
        if (this.expireClients != null) {
            this.expireClientsInt = Integer.parseInt(this.expireClients);
        } else {
            this.saveExpirationHeaders = true;
            this.expireClientsInt = -4;
        }
        this.expireCacheInt = this.expireCache != null ? Integer.parseInt(this.expireCache) : -2;
        this.layerLock = new ReentrantLock();
        this.layerLockedCond = this.layerLock.newCondition();
        this.procQueue = new HashMap();
        try {
            this.initParameters();
        }
        catch (GeoWebCacheException gwce) {
            log.error((Object)gwce.getMessage());
            gwce.printStackTrace();
        }
        if (this.metaWidthHeight == null || this.metaWidthHeight.length != 2) {
            this.metaWidthHeight = new int[2];
            this.metaWidthHeight[0] = 3;
            this.metaWidthHeight[1] = 3;
        }
        if (this.grids == null) {
            this.grids = new Hashtable();
        }
        if (this.grids.size() == 0) {
            Grid epsg4326Grid = new Grid(SRS.getEPSG4326(), BBOX.WORLD4326, BBOX.WORLD4326, null);
            Grid epsg900913Grid = new Grid(SRS.getEPSG900913(), BBOX.WORLD900913, BBOX.WORLD900913, null);
            this.grids.put(SRS.getEPSG4326(), epsg4326Grid);
            this.grids.put(SRS.getEPSG900913(), epsg900913Grid);
        }
        this.gridLocConds = new Condition[17];
        for (int i = 0; i < this.gridLocConds.length; ++i) {
            this.gridLocConds[i] = this.layerLock.newCondition();
        }
        if (this.parameterFilters != null && this.parameterFilters.size() > 0) {
            int i;
            Iterator<ParameterFilter> iter = this.parameterFilters.iterator();
            TreeMap<String, ParameterFilter> tree = new TreeMap<String, ParameterFilter>();
            while (iter.hasNext()) {
                ParameterFilter modParam = iter.next();
                String key = modParam.getKey();
                if (key.equalsIgnoreCase("STYLES")) {
                    this.stylesIsModParam = true;
                }
                tree.put(modParam.getKey(), modParam);
            }
            int arSize = tree.values().size();
            Iterator sortedIter = tree.values().iterator();
            this.sortedModParams = new ParameterFilter[arSize];
            for (i = 0; i < arSize; ++i) {
                this.sortedModParams[i] = (ParameterFilter)sortedIter.next();
            }
            this.sortedModParamsKeys = new String[this.sortedModParams.length];
            for (i = 0; i < this.sortedModParams.length; ++i) {
                this.sortedModParamsKeys[i] = this.sortedModParams[i].getKey();
            }
        }
        for (int i = 0; i < this.wmsUrl.length; ++i) {
            String url = this.wmsUrl[i];
            if (url.endsWith("?")) continue;
            this.wmsUrl[i] = url + "?";
        }
        return new Boolean(true);
    }

    @Override
    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException {
        MimeType mime = tile.getMimeType();
        if (mime == null) {
            mime = this.formats.get(0);
        }
        SRS tileSrs = tile.getSRS();
        int[] gridLoc = tile.getTileIndex();
        this.getGrid(tileSrs).getGridCalculator().locationWithinBounds(gridLoc);
        if (this.tryCacheFetch(tile)) {
            return this.finalizeTile(tile);
        }
        if (mime.supportsTiling()) {
            return this.getMetatilingReponse(tile, true);
        }
        return this.getNonMetatilingReponse(tile, true);
    }

    @Override
    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        if (tile.getMimeType().supportsTiling()) {
            this.getMetatilingReponse(tile, tryCache);
        } else {
            this.getNonMetatilingReponse(tile, tryCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getMetatilingReponse(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException {
        int[] gridLoc = tile.getTileIndex();
        GridCalculator gridCalc = this.getGrid(tile.getSRS()).getGridCalculator();
        WMSMetaTile metaTile = new WMSMetaTile(this, tile.getSRS(), tile.getMimeType(), gridCalc.getGridBounds(gridLoc[2]), gridLoc, this.metaWidthHeight[0], this.metaWidthHeight[1], tile.getFullParameters());
        if (this.saveExpirationHeaders) {
            metaTile.setExpiresHeader(-4L);
        }
        int[] metaGridLoc = metaTile.getMetaGridPos();
        GridLocObj metaGlo = new GridLocObj(metaGridLoc);
        int condIdx = this.calcLocCondIdx(metaGridLoc);
        this.waitForQueue(metaGlo, condIdx);
        try {
            if (tryCache && this.tryCacheFetch(tile)) {
                this.removeFromQueue(metaGlo, condIdx);
                ConveyorTile conveyorTile = this.finalizeTile(tile);
                return conveyorTile;
            }
            if (this.saveExpirationHeaders) {
                metaTile.setExpiresHeader(-4L);
            }
            byte[] response = WMSHttpHelper.makeRequest(metaTile);
            if (metaTile.getError() || response == null) {
                throw new GeoWebCacheException("Empty metatile, error message: " + metaTile.getErrorMessage());
            }
            if (this.saveExpirationHeaders) {
                this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
            }
            metaTile.setImageBytes(response);
            boolean useJAI = true;
            if (tile.getMimeType() == ImageMime.jpeg) {
                useJAI = false;
            }
            metaTile.createTiles(256, 256, useJAI);
            int[][] gridPositions = metaTile.getTilesGridPositions();
            tile.setContent(this.getTile(gridLoc, gridPositions, metaTile));
            if (this.expireCacheInt != -1) {
                this.saveTiles(gridPositions, metaTile, tile);
            }
        }
        finally {
            this.removeFromQueue(metaGlo, condIdx);
        }
        return this.finalizeTile(tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getNonMetatilingReponse(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException {
        int[] gridLoc = tile.getTileIndex();
        int condIdx = this.calcLocCondIdx(gridLoc);
        GridLocObj glo = new GridLocObj(gridLoc);
        this.waitForQueue(glo, condIdx);
        try {
            if (tryCache && this.tryCacheFetch(tile)) {
                this.removeFromQueue(glo, condIdx);
                ConveyorTile conveyorTile = tile;
                return conveyorTile;
            }
            if (this.saveExpirationHeaders) {
                tile.setExpiresHeader(-4L);
            }
            if ((tile = this.doNonMetatilingRequest(tile)).getStatus() > 299 || this.expireCacheInt != -1) {
                tile.persist();
            }
            if (this.saveExpirationHeaders) {
                this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
            }
        }
        finally {
            this.removeFromQueue(glo, condIdx);
        }
        return this.finalizeTile(tile);
    }

    public boolean tryCacheFetch(ConveyorTile tile) {
        if (this.expireCacheInt != -1) {
            try {
                return tile.retrieve(this.expireCacheInt * 1000);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                tile.setErrorMsg(gwce.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void setExpirationHeader(HttpServletResponse response) {
        if (this.expireClientsInt == 0) {
            return;
        }
        if (this.expireClientsInt > 0) {
            response.setHeader("Cache-Control", "max-age=" + this.expireClients + ", must-revalidate");
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(this.expireClientsInt));
        } else if (this.expireClientsInt == -2) {
            long oneYear = 31536000L;
            response.setHeader("Cache-Control", "max-age=" + oneYear);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader((int)oneYear));
        } else if (this.expireClientsInt == -1) {
            response.setHeader("Cache-Control", "no-cache");
        } else if (this.expireClientsInt == -4) {
            int seconds = 36000;
            response.setHeader("geowebcache-error", "No real CacheControl information available");
            response.setHeader("Cache-Control", "max-age=" + seconds);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(seconds));
        }
    }

    public void setTileIndexHeader(ConveyorTile tile) {
        tile.servletResp.addHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
    }

    protected void saveTiles(int[][] gridPositions, WMSMetaTile metaTile, ConveyorTile tileProto) throws GeoWebCacheException {
        for (int i = 0; i < gridPositions.length; ++i) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                boolean completed = metaTile.writeTileToStream(i, out);
                if (!completed) {
                    log.error((Object)"metaTile.writeTileToStream returned false, no tiles saved");
                }
            }
            catch (IOException ioe) {
                log.error((Object)("Unable to write image tile to ByteArrayOutputStream: " + ioe.getMessage()));
                ioe.printStackTrace();
            }
            long[] idx = new long[]{gridPositions[i][0], gridPositions[i][1], gridPositions[i][2]};
            TileObject tile = TileObject.createCompleteTileObject(this.getName(), idx, tileProto.getSRS().getNumber(), tileProto.getMimeType().getFormat(), tileProto.getParameters(), out.toByteArray());
            tileProto.getStorageBroker().put(tile);
        }
    }

    private byte[] getTile(int[] gridPos, int[][] gridPositions, WMSMetaTile metaTile) throws GeoWebCacheException {
        for (int i = 0; i < gridPositions.length; ++i) {
            int[] curPos = gridPositions[i];
            if (curPos[0] != gridPos[0] || curPos[1] != gridPos[1] || curPos[2] != gridPos[2]) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                metaTile.writeTileToStream(i, out);
            }
            catch (IOException ioe) {
                log.error((Object)("Unable to write image tile to ByteArrayOutputStream: " + ioe.getMessage()));
                ioe.printStackTrace();
            }
            byte[] data = out.toByteArray();
            return data;
        }
        throw new GeoWebCacheException("Bug: WMSLayer.getTile() didn't have tile...");
    }

    @Override
    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        byte[] response = WMSHttpHelper.makeRequest(tile);
        if (tile.getError() || response == null) {
            throw new GeoWebCacheException("Empty tile, error message: " + tile.getErrorMessage());
        }
        tile.setContent(response);
        return tile;
    }

    private ConveyorTile finalizeTile(ConveyorTile tile) {
        if (tile.getStatus() == 0 && !tile.getError()) {
            tile.setStatus(200);
        }
        if (tile != null && tile.servletResp != null) {
            this.setExpirationHeader(tile.servletResp);
            this.setTileIndexHeader(tile);
        }
        return tile;
    }

    private void initParameters() throws GeoWebCacheException {
        if (this.expireCacheInt == -4 || this.expireClientsInt == -4) {
            this.saveExpirationHeaders = true;
        }
        this.formats = new ArrayList<MimeType>();
        if (this.mimeFormats != null) {
            for (String fmt : this.mimeFormats) {
                this.formats.add(MimeType.createFromFormat(fmt));
            }
        }
        if (this.formats.size() == 0) {
            this.formats.add(0, ImageMime.createFromFormat("image/png"));
            this.formats.add(1, ImageMime.createFromFormat("image/jpeg"));
        }
    }

    protected void saveExpirationInformation(int backendExpire) {
        this.saveExpirationHeaders = false;
        try {
            if (this.expireCacheInt == -4) {
                if (backendExpire == -1) {
                    this.expireCacheInt = 7200;
                    log.error((Object)"Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                } else {
                    this.expireCacheInt = backendExpire;
                }
                log.trace((Object)("Setting expireCache to: " + this.expireCache));
            }
            if (this.expireClientsInt == -4) {
                if (backendExpire == -1) {
                    this.expireClientsInt = 7200;
                    log.error((Object)"Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                } else {
                    this.expireClientsInt = backendExpire;
                }
                log.trace((Object)("Setting expireClients to: " + this.expireClients));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MimeType getImageFormat(String strFormat) throws MimeException {
        if (strFormat == null) {
            return this.formats.get(0);
        }
        return MimeType.createFromFormat(strFormat);
    }

    public String getWMSRequestTemplate() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SERVICE=WMS");
        strBuilder.append("&REQUEST=GetMap");
        strBuilder.append("&VERSION=");
        if (this.wmsVersion != null) {
            strBuilder.append(this.wmsVersion);
        } else {
            strBuilder.append("1.1.0");
        }
        strBuilder.append("&LAYERS=");
        if (this.wmsLayers != null && this.wmsLayers.length() != 0) {
            strBuilder.append(this.wmsLayers);
        } else {
            strBuilder.append(this.name);
        }
        strBuilder.append("&EXCEPTIONS=");
        if (this.errorMime != null) {
            strBuilder.append(this.errorMime);
        } else {
            strBuilder.append(ErrorMime.vnd_ogc_se_inimage.getMimeType());
        }
        if (!this.stylesIsModParam) {
            strBuilder.append("&STYLES=");
            if (this.wmsStyles != null && this.wmsStyles.length() != 0) {
                strBuilder.append(this.wmsStyles);
            }
        }
        if (this.transparent != null) {
            if (this.transparent.booleanValue()) {
                strBuilder.append("&TRANSPARENT=").append("TRUE");
            } else {
                strBuilder.append("&TRANSPARENT=").append("FALSE");
            }
        }
        if (this.bgColor != null && this.bgColor.length() != 0) {
            strBuilder.append("&BGCOLOR=").append(this.bgColor);
        }
        if (this.palette != null && this.palette.length() != 0) {
            strBuilder.append("&PALETTE=").append(this.palette);
        }
        if (this.vendorParameters != null && this.vendorParameters.length() != 0) {
            if (!this.vendorParameters.startsWith("&")) {
                strBuilder.append("&");
            }
            strBuilder.append(this.vendorParameters);
        }
        return strBuilder.toString();
    }

    protected String nextWmsURL() {
        this.curWmsURL = (this.curWmsURL + 1) % this.wmsUrl.length;
        return this.wmsUrl[this.curWmsURL];
    }

    @Override
    public void destroy() {
        this.procQueue.clear();
    }

    @Override
    public int[][] getCoveredGridLevels(SRS srs, BBOX bounds) throws GeoWebCacheException {
        BBOX adjustedBounds = bounds;
        Grid grid = (Grid)this.grids.get(srs);
        if (!grid.getBounds().contains(bounds)) {
            adjustedBounds = BBOX.intersection(grid.getBounds(), bounds);
            log.warn((Object)("Adjusting bounds from " + bounds.toString() + " to " + adjustedBounds.toString()));
        }
        return grid.getGridCalculator().coveredGridLevels(adjustedBounds);
    }

    @Override
    public int[] getMetaTilingFactors() {
        return this.metaWidthHeight;
    }

    @Override
    public int[] getGridLocForBounds(SRS srs, BBOX tileBounds) throws GeoWebCacheException {
        return ((Grid)this.grids.get(srs)).getGridCalculator().gridLocation(tileBounds);
    }

    @Override
    public MimeType getDefaultMimeType() {
        return this.formats.get(0);
    }

    @Override
    public BBOX getBboxForGridLoc(SRS srs, int[] gridLoc) throws GeoWebCacheException {
        return ((Grid)this.grids.get(srs)).getGridCalculator().bboxFromGridLocation(gridLoc);
    }

    @Override
    public int[][] getZoomInGridLoc(SRS srs, int[] gridLoc) throws GeoWebCacheException {
        return ((Grid)this.grids.get(srs)).getGridCalculator().getZoomInGridLoc(gridLoc);
    }

    @Override
    public int[] getZoomedOutGridLoc(SRS srs) throws GeoWebCacheException {
        return ((Grid)this.grids.get(srs)).getGridCalculator().getZoomedOutGridLoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLayerLock() {
        boolean wait = true;
        while (wait) {
            try {
                this.layerLock.lock();
                this.layerLocked = true;
                if (this.procQueue != null && this.procQueue.size() != 0) continue;
                wait = false;
            }
            finally {
                this.layerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLayerLock() {
        this.layerLock.lock();
        try {
            this.layerLocked = false;
            this.layerLockedCond.signalAll();
        }
        finally {
            this.layerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForQueue(GridLocObj glo, int condIdx) {
        boolean retry = true;
        boolean hasWaited = false;
        while (retry) {
            this.layerLock.lock();
            try {
                if (this.layerLocked) {
                    this.layerLockedCond.await();
                    continue;
                }
                if (this.procQueue.containsKey(glo)) {
                    hasWaited = true;
                    this.gridLocConds[condIdx].await();
                    continue;
                }
                this.procQueue.put(glo, true);
                retry = false;
            }
            catch (InterruptedException ie) {}
            continue;
            finally {
                this.layerLock.unlock();
            }
        }
        return hasWaited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromQueue(GridLocObj glo, int condIdx) {
        this.layerLock.lock();
        try {
            this.procQueue.remove(glo);
            this.gridLocConds[condIdx].signalAll();
        }
        finally {
            this.layerLock.unlock();
        }
    }

    private int calcLocCondIdx(int[] gridLoc) {
        return (gridLoc[0] * 7 + gridLoc[1] * 13 + gridLoc[2] * 5) % this.gridLocConds.length;
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return this.formats;
    }

    @Override
    public String getStyles() {
        return this.wmsStyles;
    }

    @Override
    public void putTile(ConveyorTile tile) throws GeoWebCacheException {
        int condIdx = this.calcLocCondIdx(tile.getTileIndex());
        GridLocObj glo = new GridLocObj(tile.getTileIndex());
        this.waitForQueue(glo, condIdx);
        if (this.expireCacheInt != -1) {
            tile.persist();
        }
        this.removeFromQueue(glo, condIdx);
    }

    public void setErrorMime(String errormime) {
        this.errorMime = errormime;
    }

    public void addMetaWidthHeight(int w, int h) {
        this.metaWidthHeight[0] = w;
        this.metaWidthHeight[1] = h;
    }

    public void setWMSurl(String[] wmsurl) {
        this.wmsUrl = wmsurl;
    }

    public String[] getWMSurl() {
        return this.wmsUrl;
    }

    @Override
    public Boolean isCacheBypassAllowed() {
        return this.cacheBypassAllowed;
    }

    @Override
    public void isCacheBypassAllowed(boolean allowed) {
        this.cacheBypassAllowed = allowed;
    }

    @Override
    public Integer getBackendTimeout() {
        return this.backendTimeout;
    }

    @Override
    public void setBackendTimeout(int seconds) {
        this.backendTimeout = seconds;
    }

    public void setVersion(String version) {
        this.wmsVersion = version;
    }

    public void setTiled(boolean tiled) {
        this.tiled = tiled;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setDebugHeaders(boolean debugheaders) {
    }

    @Override
    public ConveyorTile getNoncachedTile(ConveyorTile tile, boolean requestTiled) throws GeoWebCacheException {
        byte[] data = WMSHttpHelper.makeRequest(tile, requestTiled);
        tile.setContent(data);
        return tile;
    }

    public String[] getModifiableParameters(Map<String, String[]> map) throws GeoWebCacheException {
        String[] paramStrs = new String[2];
        if (this.sortedModParamsKeys == null) {
            return null;
        }
        String[] values = ServletUtils.selectedStringsFromMap(map, this.sortedModParamsKeys);
        StringBuilder strModifiers = new StringBuilder();
        StringBuilder strFull = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            ParameterFilter modParam = this.sortedModParams[i];
            if (value == null || value.length() == 0) {
                strFull.append("&").append(modParam.getKey()).append("=").append(modParam.getDefaultValue());
                continue;
            }
            String filteredValue = modParam.apply(value);
            strModifiers.append("&").append(modParam.getKey()).append("=").append(filteredValue);
        }
        paramStrs[1] = strModifiers.toString();
        paramStrs[0] = strFull.append((CharSequence)strModifiers).toString();
        return paramStrs;
    }

    public void mergeWith(WMSLayer otherLayer) throws GeoWebCacheException {
        if (otherLayer.parameterFilters != null) {
            if (this.parameterFilters != null) {
                Iterator<ParameterFilter> iter = otherLayer.parameterFilters.iterator();
                while (iter.hasNext()) {
                    this.parameterFilters.add(iter.next());
                }
            } else {
                this.parameterFilters = otherLayer.parameterFilters;
            }
        }
    }
}

