/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.mime.MimeType;

public abstract class MetaTile
implements TileResponseReceiver {
    private static Log log = LogFactory.getLog(MetaTile.class);
    protected int[] metaTileGridBounds = null;
    protected int[][] tilesGridPositions = null;
    protected int metaX;
    protected int metaY;
    protected SRS srs;
    protected long status = -1L;
    protected boolean error = false;
    protected String errorMessage;
    protected long expiresHeader = -1L;
    protected MimeType mimeType;

    protected MetaTile(SRS srs, MimeType mimeType, int[] gridBounds, int[] tileGridPosition, int metaX, int metaY) {
        this.srs = srs;
        this.mimeType = mimeType;
        this.metaX = metaX;
        this.metaY = metaY;
        this.metaTileGridBounds = this.calculateMetaTileGridBounds(gridBounds, tileGridPosition);
        this.tilesGridPositions = this.calculateTilesGridPositions();
    }

    public int getStatus() {
        return (int)this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError() {
        this.error = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getExpiresHeader() {
        return this.expiresHeader;
    }

    public void setExpiresHeader(long seconds) {
        this.expiresHeader = seconds;
    }

    private int[] calculateMetaTileGridBounds(int[] gridBounds, int[] tileGridPosition) {
        int[] metaTileGridBounds;
        metaTileGridBounds = new int[]{tileGridPosition[0] - tileGridPosition[0] % this.metaX, tileGridPosition[1] - tileGridPosition[1] % this.metaY, Math.min(metaTileGridBounds[0] + this.metaX - 1, gridBounds[2]), Math.min(metaTileGridBounds[1] + this.metaY - 1, gridBounds[3]), tileGridPosition[2]};
        this.metaX = metaTileGridBounds[2] - metaTileGridBounds[0] + 1;
        this.metaY = metaTileGridBounds[3] - metaTileGridBounds[1] + 1;
        return metaTileGridBounds;
    }

    private int[][] calculateTilesGridPositions() {
        if (this.metaX < 0 || this.metaY < 0) {
            return null;
        }
        int[][] tilesGridPositions = new int[this.metaX * this.metaY][3];
        try {
            for (int y = 0; y < this.metaY; ++y) {
                for (int x = 0; x < this.metaX; ++x) {
                    int tile = y * this.metaX + x;
                    tilesGridPositions[tile][0] = this.metaTileGridBounds[0] + x;
                    tilesGridPositions[tile][1] = this.metaTileGridBounds[1] + y;
                    tilesGridPositions[tile][2] = this.metaTileGridBounds[4];
                }
            }
        }
        catch (NullPointerException npe) {
            log.error((Object)"Null pointer exception in calculateTilesGridositions()");
        }
        return tilesGridPositions;
    }

    public int[] getMetaGridPos() {
        int[] gridPos = new int[]{this.metaTileGridBounds[0], this.metaTileGridBounds[1], this.metaTileGridBounds[4]};
        return gridPos;
    }

    public int[] getMetaTileGridBounds() {
        return this.metaTileGridBounds;
    }

    public int[][] getTilesGridPositions() {
        return this.tilesGridPositions;
    }

    public SRS getSRS() {
        return this.srs;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }
}

