/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.SWIGTYPE_p_GIntBig;
import org.gdal.ogr.ogrJNI;
import org.gdal.osr.SpatialReference;

public class Layer {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Layer(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Layer obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtrAndDisown(Layer obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
        }
        return Layer.getCPtr(obj);
    }

    public int GetRefCount() {
        return ogrJNI.Layer_GetRefCount(this.swigCPtr, this);
    }

    public void SetSpatialFilter(Geometry filter) {
        ogrJNI.Layer_SetSpatialFilter(this.swigCPtr, this, Geometry.getCPtr(filter), filter);
    }

    public void SetSpatialFilterRect(double minx, double miny, double maxx, double maxy) {
        ogrJNI.Layer_SetSpatialFilterRect(this.swigCPtr, this, minx, miny, maxx, maxy);
    }

    public Geometry GetSpatialFilter() {
        long cPtr = ogrJNI.Layer_GetSpatialFilter(this.swigCPtr, this);
        return cPtr == 0L ? null : new Geometry(cPtr, false);
    }

    public int SetAttributeFilter(String filter_string) {
        return ogrJNI.Layer_SetAttributeFilter(this.swigCPtr, this, filter_string);
    }

    public void ResetReading() {
        ogrJNI.Layer_ResetReading(this.swigCPtr, this);
    }

    public String GetName() {
        return ogrJNI.Layer_GetName(this.swigCPtr, this);
    }

    public Feature GetFeature(int fid) {
        long cPtr = ogrJNI.Layer_GetFeature(this.swigCPtr, this, fid);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public Feature GetNextFeature() {
        long cPtr = ogrJNI.Layer_GetNextFeature(this.swigCPtr, this);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public int SetNextByIndex(int new_index) {
        return ogrJNI.Layer_SetNextByIndex(this.swigCPtr, this, new_index);
    }

    public int SetFeature(Feature feature) {
        return ogrJNI.Layer_SetFeature(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int CreateFeature(Feature feature) {
        return ogrJNI.Layer_CreateFeature(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int DeleteFeature(int fid) {
        return ogrJNI.Layer_DeleteFeature(this.swigCPtr, this, fid);
    }

    public int SyncToDisk() {
        return ogrJNI.Layer_SyncToDisk(this.swigCPtr, this);
    }

    public FeatureDefn GetLayerDefn() {
        long cPtr = ogrJNI.Layer_GetLayerDefn(this.swigCPtr, this);
        return cPtr == 0L ? null : new FeatureDefn(cPtr, false);
    }

    public int GetFeatureCount(int force) {
        return ogrJNI.Layer_GetFeatureCount(this.swigCPtr, this, force);
    }

    public int GetExtent(double[] argout, int force) {
        return ogrJNI.Layer_GetExtent(this.swigCPtr, this, argout, force);
    }

    public boolean TestCapability(String cap) {
        return ogrJNI.Layer_TestCapability(this.swigCPtr, this, cap);
    }

    public int CreateField(FieldDefn field_def, int approx_ok) {
        return ogrJNI.Layer_CreateField(this.swigCPtr, this, FieldDefn.getCPtr(field_def), field_def, approx_ok);
    }

    public int StartTransaction() {
        return ogrJNI.Layer_StartTransaction(this.swigCPtr, this);
    }

    public int CommitTransaction() {
        return ogrJNI.Layer_CommitTransaction(this.swigCPtr, this);
    }

    public int RollbackTransaction() {
        return ogrJNI.Layer_RollbackTransaction(this.swigCPtr, this);
    }

    public SpatialReference GetSpatialRef() {
        long cPtr = ogrJNI.Layer_GetSpatialRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public SWIGTYPE_p_GIntBig GetFeatureRead() {
        return new SWIGTYPE_p_GIntBig(ogrJNI.Layer_GetFeatureRead(this.swigCPtr, this), true);
    }
}

