/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.util.Vector;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogrJNI;
import org.gdal.osr.SpatialReference;

public class DataSource {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected DataSource(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DataSource obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            ogrJNI.delete_DataSource(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtrAndDisown(DataSource obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
        }
        return DataSource.getCPtr(obj);
    }

    public String getName() {
        return ogrJNI.DataSource_name_get(this.swigCPtr, this);
    }

    public int GetRefCount() {
        return ogrJNI.DataSource_GetRefCount(this.swigCPtr, this);
    }

    public int GetSummaryRefCount() {
        return ogrJNI.DataSource_GetSummaryRefCount(this.swigCPtr, this);
    }

    public int GetLayerCount() {
        return ogrJNI.DataSource_GetLayerCount(this.swigCPtr, this);
    }

    public Driver GetDriver() {
        long cPtr = ogrJNI.DataSource_GetDriver(this.swigCPtr, this);
        return cPtr == 0L ? null : new Driver(cPtr, false);
    }

    public String GetName() {
        return ogrJNI.DataSource_GetName(this.swigCPtr, this);
    }

    public int DeleteLayer(int index) {
        return ogrJNI.DataSource_DeleteLayer(this.swigCPtr, this, index);
    }

    public Layer CreateLayer(String name, SpatialReference reference, int geom_type, Vector options) {
        long cPtr = ogrJNI.DataSource_CreateLayer(this.swigCPtr, this, name, SpatialReference.getCPtr(reference), reference, geom_type, options);
        return cPtr == 0L ? null : new Layer(cPtr, false);
    }

    public Layer CopyLayer(Layer src_layer, String new_name, Vector options) {
        long cPtr = ogrJNI.DataSource_CopyLayer(this.swigCPtr, this, Layer.getCPtr(src_layer), src_layer, new_name, options);
        return cPtr == 0L ? null : new Layer(cPtr, false);
    }

    public Layer GetLayerByIndex(int index) {
        long cPtr = ogrJNI.DataSource_GetLayerByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Layer(cPtr, false);
    }

    public Layer GetLayerByName(String layer_name) {
        long cPtr = ogrJNI.DataSource_GetLayerByName(this.swigCPtr, this, layer_name);
        return cPtr == 0L ? null : new Layer(cPtr, false);
    }

    public boolean TestCapability(String cap) {
        return ogrJNI.DataSource_TestCapability(this.swigCPtr, this, cap);
    }

    public Layer ExecuteSQL(String statement, Geometry geom, String dialect) {
        long cPtr = ogrJNI.DataSource_ExecuteSQL(this.swigCPtr, this, statement, Geometry.getCPtr(geom), geom, dialect);
        return cPtr == 0L ? null : new Layer(cPtr, true);
    }

    public void ReleaseResultSet(Layer layer) {
        ogrJNI.DataSource_ReleaseResultSet(this.swigCPtr, this, Layer.getCPtrAndDisown(layer), layer);
    }
}

