/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.gdal;

import java.nio.ByteBuffer;
import org.gdal.gdal.ColorTable;
import org.gdal.gdal.MajorObject;
import org.gdal.gdal.gdalJNI;

public class Band
extends MajorObject {
    private long swigCPtr;

    protected Band(long cPtr, boolean cMemoryOwn) {
        super(gdalJNI.SWIGBandUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Band obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtrAndDisown(Band obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
        }
        return Band.getCPtr(obj);
    }

    public int getXSize() {
        return gdalJNI.Band_XSize_get(this.swigCPtr, this);
    }

    public int getYSize() {
        return gdalJNI.Band_YSize_get(this.swigCPtr, this);
    }

    public int getDataType() {
        return gdalJNI.Band_DataType_get(this.swigCPtr, this);
    }

    public void GetBlockSize(int[] pnBlockXSize, int[] pnBlockYSize) {
        gdalJNI.Band_GetBlockSize(this.swigCPtr, this, pnBlockXSize, pnBlockYSize);
    }

    public int GetRasterColorInterpretation() {
        return gdalJNI.Band_GetRasterColorInterpretation(this.swigCPtr, this);
    }

    public int SetRasterColorInterpretation(int val) {
        return gdalJNI.Band_SetRasterColorInterpretation(this.swigCPtr, this, val);
    }

    public void GetNoDataValue(Double[] val) {
        gdalJNI.Band_GetNoDataValue(this.swigCPtr, this, val);
    }

    public int SetNoDataValue(double d) {
        return gdalJNI.Band_SetNoDataValue(this.swigCPtr, this, d);
    }

    public void GetMinimum(Double[] val) {
        gdalJNI.Band_GetMinimum(this.swigCPtr, this, val);
    }

    public void GetMaximum(Double[] val) {
        gdalJNI.Band_GetMaximum(this.swigCPtr, this, val);
    }

    public void GetOffset(Double[] val) {
        gdalJNI.Band_GetOffset(this.swigCPtr, this, val);
    }

    public void GetScale(Double[] val) {
        gdalJNI.Band_GetScale(this.swigCPtr, this, val);
    }

    public int GetStatistics(int approx_ok, int force, double[] min, double[] max, double[] mean, double[] stddev) {
        return gdalJNI.Band_GetStatistics(this.swigCPtr, this, approx_ok, force, min, max, mean, stddev);
    }

    public int SetStatistics(double min, double max, double mean, double stddev) {
        return gdalJNI.Band_SetStatistics(this.swigCPtr, this, min, max, mean, stddev);
    }

    public int GetOverviewCount() {
        return gdalJNI.Band_GetOverviewCount(this.swigCPtr, this);
    }

    public Band GetOverview(int i) {
        long cPtr = gdalJNI.Band_GetOverview(this.swigCPtr, this, i);
        return cPtr == 0L ? null : new Band(cPtr, false);
    }

    public int Checksum(int xoff, int yoff, int[] xsize, int[] ysize) {
        return gdalJNI.Band_Checksum(this.swigCPtr, this, xoff, yoff, xsize, ysize);
    }

    public void ComputeRasterMinMax(double[] argout, int approx_ok) {
        gdalJNI.Band_ComputeRasterMinMax(this.swigCPtr, this, argout, approx_ok);
    }

    public void ComputeBandStats(double[] argout, int samplestep) {
        gdalJNI.Band_ComputeBandStats(this.swigCPtr, this, argout, samplestep);
    }

    public int Fill(double real_fill, double imag_fill) {
        return gdalJNI.Band_Fill(this.swigCPtr, this, real_fill, imag_fill);
    }

    public int ReadRaster(int xoff, int yoff, int xsize, int ysize, char[][] buf_len, int[] buf_xsize, int[] buf_ysize, int[] buf_type) {
        return gdalJNI.Band_ReadRaster(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_len, buf_xsize, buf_ysize, buf_type);
    }

    public int WriteRaster(int xoff, int yoff, int xsize, int ysize, char[] buf_len, int[] buf_xsize, int[] buf_ysize, int[] buf_type) {
        return gdalJNI.Band_WriteRaster(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_len, buf_xsize, buf_ysize, buf_type);
    }

    public void FlushCache() {
        gdalJNI.Band_FlushCache(this.swigCPtr, this);
    }

    public ColorTable GetRasterColorTable() {
        long cPtr = gdalJNI.Band_GetRasterColorTable(this.swigCPtr, this);
        return cPtr == 0L ? null : new ColorTable(cPtr, false);
    }

    public int SetRasterColorTable(ColorTable arg) {
        return gdalJNI.Band_SetRasterColorTable(this.swigCPtr, this, ColorTable.getCPtr(arg), arg);
    }

    public int ReadRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer buf) {
        return gdalJNI.Band_ReadRaster_Direct(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, buf);
    }

    public int WriteRaster_Direct(int xoff, int yoff, int xsize, int ysize, int buf_xsize, int buf_ysize, int buf_type, ByteBuffer buf) {
        return gdalJNI.Band_WriteRaster_Direct(this.swigCPtr, this, xoff, yoff, xsize, ysize, buf_xsize, buf_ysize, buf_type, buf);
    }
}

