/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.List;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.BandMergeNode;
import org.geotools.renderer.lite.gridcoverage2d.BandSelectionNode;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.RootNode;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

class ChannelSelectionNode
extends SubchainStyleVisitorCoverageProcessingAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private static final Logger LOGGER = Logger.getLogger(ChannelSelectionNode.class.getName());

    public InternationalString getName() {
        return Vocabulary.formatInternational(4);
    }

    public ChannelSelectionNode() {
        this((Hints)null);
    }

    public ChannelSelectionNode(Hints hints) {
        super(3, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ChannelSelectionNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a ChannelSelection following SLD 1.0 spec."));
    }

    public synchronized void visit(ChannelSelection cs) {
        List<CoverageProcessingNode> localSources = this.getSources();
        int length = localSources.size();
        if (length == 0) {
            throw new IllegalArgumentException(Errors.format(3, "ChannelSelectionNode"));
        }
        GridCoverage2D source = (GridCoverage2D)this.getSource(0).getOutput();
        ChannelSelectionNode.ensureSourceNotNull(source, this.getName().toString());
        RootNode chainSource = new RootNode(source, this.getHints());
        BandMergeNode subChainSink = new BandMergeNode(this.getHints());
        this.setSink(subChainSink);
        SelectedChannelType[] sc = cs.getSelectedChannels();
        if (sc != null && sc.length > 0) {
            if (sc.length != 3 && sc.length != 1) {
                throw new IllegalArgumentException(Errors.format(7, new Integer(sc.length)));
            }
            for (int i = 0; i < sc.length; ++i) {
                SelectedChannelType channel = sc[i];
                BandSelectionNode bandSelectionNode = new BandSelectionNode();
                bandSelectionNode.addSource(chainSource);
                bandSelectionNode.visit(channel);
                ContrastEnhancementNode contrastenhancementNode = new ContrastEnhancementNode();
                contrastenhancementNode.addSource(bandSelectionNode);
                bandSelectionNode.addSink(contrastenhancementNode);
                contrastenhancementNode.visit(channel != null ? channel.getContrastEnhancement() : null);
                contrastenhancementNode.addSink(subChainSink);
                subChainSink.addSource(contrastenhancementNode);
            }
        } else {
            subChainSink.addSource(chainSource);
        }
    }
}

